package com.paystack.android_sdk.ui.components.views.inputs.validators

import androidx.annotation.DrawableRes
import androidx.annotation.StringRes
import com.paystack.android_sdk.ui.R

internal enum class CardType {
    VISA,
    MASTERCARD,
    MAESTRO,
    AMEX,
    JCB,
    DINERS_CLUB,
    DISCOVER,
    VERVE,
    UNKNOWN;

    val logoRes: Int
        @DrawableRes get() = when (this) {
            VISA -> R.drawable.pstk_visa
            AMEX -> R.drawable.pstk_amex
            DINERS_CLUB -> R.drawable.pstk_diners
            JCB -> R.drawable.pstk_jcb
            DISCOVER -> R.drawable.pstk_discover
            MAESTRO -> R.drawable.pstk_maestro
            MASTERCARD -> R.drawable.pstk_mastercard
            VERVE -> R.drawable.pstk_verve
            UNKNOWN -> R.drawable.pstk_unknown
        }
    val nameRes: Int
        @StringRes get() = when (this) {
            VISA -> R.string.pstk_card_scheme_visa
            AMEX -> R.string.pstk_card_scheme_amex
            DINERS_CLUB -> R.string.pstk_card_scheme_diners
            JCB -> R.string.pstk_card_scheme_jcb
            DISCOVER -> R.string.pstk_card_scheme_discover
            MAESTRO -> R.string.pstk_card_scheme_maestro
            MASTERCARD -> R.string.pstk_card_scheme_mastercard
            VERVE -> R.string.pstk_card_scheme_verve
            UNKNOWN -> R.string.pstk_unknown
        }

    /**
     * Default card number length for card type.
     * For certain card types, the length depends on the BIN. E.g. [DINERS_CLUB]
     * This value should act as a fallback in those cases.
     */
    val maxPanLength: Int
        get() = when (this) {
            AMEX -> 15
            VERVE, MAESTRO, JCB -> 19
            DINERS_CLUB -> 14
            UNKNOWN -> 20
            else -> 16
        }

    /**
     * The maximum CVV length for the [CardType].
     */
    val maxCvvLength: Int
        get() = when (this) {
            AMEX -> 4
            else -> 3
        }
}
