package com.paystack.android_sdk.ui.components.success

import androidx.compose.foundation.Image
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.Surface
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.tooling.preview.Preview
import com.paystack.android_sdk.ui.R
import com.paystack.android_sdk.ui.theme.PaystackTheme
import com.paystack.android_sdk.ui.utilities.CurrencyFormatter
import com.paystack.androiddesignsystem.PaystackTheme

@Composable
internal fun PaymentSuccessful(
    amount: Long,
    currencyCode: String,
    merchantName: String,
    modifier: Modifier = Modifier
) {
    Column(
        modifier = modifier
            .fillMaxSize()
            .padding(PaystackTheme.dimensions.spacing.double),
        verticalArrangement = Arrangement.Center,
        horizontalAlignment = Alignment.CenterHorizontally,
    ) {
        Image(painter = painterResource(R.drawable.pstk_ic_success), contentDescription = null)
        Spacer(modifier = Modifier.height(PaystackTheme.dimensions.spacing.single))

        Text(
            text = stringResource(R.string.pstk_result_screen_success_title),
            style = PaystackTheme.typography.heading.heading3
        )
        Spacer(modifier = Modifier.height(PaystackTheme.dimensions.spacing.half))

        Text(
            text = stringResource(
                R.string.pstk_result_screen_success_subtitle,
                CurrencyFormatter.format(amount, currencyCode),
                merchantName
            ),
            style = PaystackTheme.typography.body.body16R,
            color = PaystackTheme.colors.primaryColors.navy03
        )
    }
}

@Preview
@Composable
internal fun PaymentSuccessfulPreview() {
    PaystackTheme {
        Surface {
            PaymentSuccessful(
                amount = 10050L,
                currencyCode = "NGN",
                merchantName = "ShopLyft"
            )
        }
    }
}
