package com.paystack.android_sdk.ui.paymentchannels.card.cardform.models

import com.paystack.android_sdk.ui.components.views.inputs.validators.CardExpirationDateFormatter
import com.paystack.android_sdk.ui.components.views.inputs.validators.CardType
import com.paystack.android_sdk.ui.components.views.inputs.validators.CardValidationUtils

internal data class CardFormData(
    val cardNumber: String = "",
    val cardExpiry: String = "",
    val cardCVV: String = ""
) {
    val isCardNumberValid: Boolean
        get() = CardValidationUtils.isCardValid(cardNumber)

    val isExpiryDateValid: Boolean
        get() {
            val formattedExpiryDate = CardExpirationDateFormatter.formatEnteredCardDate(cardExpiry)
            return CardValidationUtils.isCardExpiryDateValid(formattedExpiryDate)
        }

    val cardType: CardType
        get() = CardValidationUtils.checkCardScheme(cardNumber)
    val isCvvValid: Boolean
        get() = cardCVV.length == cardType.maxCvvLength

    val isValid: Boolean
        get() = isCardNumberValid && isExpiryDateValid && isCvvValid
}
