package com.paystack.android_sdk.ui.paymentchannels.card.cardform.models

import androidx.annotation.StringRes
import com.paystack.android_sdk.core.api.models.CardParams
import com.paystack.android_sdk.ui.R
import com.paystack.android_sdk.ui.components.views.inputs.validators.CardType
import com.paystack.android_sdk.ui.components.views.inputs.validators.CardValidationUtils

internal data class TestCard(
    val expectedResult: ExpectedResult,
    val number: String,
    val cvv: String,
    val month: String,
    val year: String,
) {
    val nameRes: Int
        @StringRes get() = when (expectedResult) {
            ExpectedResult.SUCCESS -> R.string.success
            ExpectedResult.BANK_AUTH -> R.string.bank_authentication
            ExpectedResult.DECLINED -> R.string.declined
        }

    val cardScheme: CardType
        get() = CardValidationUtils.checkCardScheme(number)

    fun toCardParams() = CardParams(
        number = number,
        cvv = cvv,
        expiryMonth = month,
        expiryYear = year,
    )

    enum class ExpectedResult {
        SUCCESS,
        BANK_AUTH,
        DECLINED,
    }

    companion object {
        fun all() = listOf(
            TestCard(
                expectedResult = ExpectedResult.SUCCESS,
                number = "4084084084084081",
                cvv = "408",
                month = "12",
                year = "30"
            ),
            TestCard(
                expectedResult = ExpectedResult.BANK_AUTH,
                number = "4084080000000409",
                cvv = "000",
                month = "01",
                year = "30"
            ),
            TestCard(
                expectedResult = ExpectedResult.DECLINED,
                number = "4084080000005408",
                cvv = "001",
                month = "01",
                year = "30"
            ),
        )
    }
}
