/*
 * Decompiled with CFR 0.152.
 */
package com.paystack.android_sdk.ui.components.views.inputs.validators;

import com.paystack.android_sdk.ui.components.views.inputs.validators.CardType;
import java.util.List;
import kotlin.Metadata;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bJ\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/paystack/android_sdk/ui/components/views/inputs/validators/CardValidationUtils;", "", "()V", "DEFAULT_CARD_LENGTH", "", "checkCardScheme", "Lcom/paystack/android_sdk/ui/components/views/inputs/validators/CardType;", "cardNumber", "", "getCardCvvLength", "cardType", "getCardNumberLength", "isCardExpiryDateValid", "", "enteredDate", "isCardValid", "paystack-ui_release"})
public final class CardValidationUtils {
    @NotNull
    public static final CardValidationUtils INSTANCE = new CardValidationUtils();
    public static final int DEFAULT_CARD_LENGTH = 14;

    private CardValidationUtils() {
    }

    @NotNull
    public final CardType checkCardScheme(@NotNull String cardNumber) {
        Intrinsics.checkNotNullParameter((Object)cardNumber, (String)"cardNumber");
        Regex visa = new Regex("^4[0-9]{0,15}$");
        Regex masterCard = new Regex("^5[1-5][0-9]{0,14}$|^2(22[1-9][0-9]{0,12}|2[3-9][0-9]{0,13}|[3-6][0-9]{0,14}|7[01][0-9]{0,13}|720[0-9]{0,12})$");
        Regex maestro = new Regex("^(5018|5020|5038|5893|6304|6390|67[0-9]{2})[0-9]{5,14}$");
        Regex amex = new Regex("^3[47][0-9]{0,13}$");
        Regex verve = new Regex("^((506([01]))|(507([89]))|(6500))[0-9]{0,19}$");
        Regex diners = new Regex("^3(?:0[0-5]|[68][0-9])[0-9]{0,11}$");
        Regex discover = new Regex("^6(?:011|5[0-9]{2}|4[4-9][0-9]|22[1-9])\\d*");
        Regex jcb = new Regex("^35(?:2[89]|[3-8][0-9])\\d*");
        String unformattedCardNumber = StringsKt.replace$default((String)cardNumber, (String)" ", (String)"", (boolean)false, (int)4, null);
        return visa.matches((CharSequence)unformattedCardNumber) ? CardType.VISA : (masterCard.matches((CharSequence)unformattedCardNumber) ? CardType.MASTERCARD : (maestro.matches((CharSequence)unformattedCardNumber) ? CardType.MAESTRO : (amex.matches((CharSequence)unformattedCardNumber) ? CardType.AMEX : (diners.matches((CharSequence)unformattedCardNumber) ? CardType.DINERS_CLUB : (discover.matches((CharSequence)unformattedCardNumber) ? CardType.DISCOVER : (jcb.matches((CharSequence)unformattedCardNumber) ? CardType.JCB : (verve.matches((CharSequence)unformattedCardNumber) ? CardType.VERVE : CardType.UNKNOWN)))))));
    }

    public final int getCardNumberLength(@NotNull CardType cardType) {
        int n;
        Intrinsics.checkNotNullParameter((Object)((Object)cardType), (String)"cardType");
        switch (WhenMappings.$EnumSwitchMapping$0[cardType.ordinal()]) {
            case 1: {
                n = 15;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n = 19;
                break;
            }
            case 5: {
                n = 14;
                break;
            }
            case 6: {
                n = 20;
                break;
            }
            default: {
                n = 16;
            }
        }
        return n;
    }

    public final int getCardCvvLength(@NotNull CardType cardType) {
        Intrinsics.checkNotNullParameter((Object)((Object)cardType), (String)"cardType");
        return WhenMappings.$EnumSwitchMapping$0[cardType.ordinal()] == 1 ? 4 : 3;
    }

    public final boolean isCardValid(@NotNull String cardNumber) {
        int n;
        Intrinsics.checkNotNullParameter((Object)cardNumber, (String)"cardNumber");
        String sanitizedCardNumber = StringsKt.replace$default((String)cardNumber, (String)" ", (String)"", (boolean)false, (int)4, null);
        if (cardNumber.length() < 14) {
            return false;
        }
        int checksum = 0;
        int i = n = sanitizedCardNumber.length() - 1;
        int n2 = ProgressionUtilKt.getProgressionLastElement((int)n, (int)0, (int)-2);
        if (n2 <= i) {
            while (true) {
                checksum += sanitizedCardNumber.charAt(i) - 48;
                if (i == n2) break;
                i -= 2;
            }
        }
        i = n = sanitizedCardNumber.length() - 2;
        n2 = ProgressionUtilKt.getProgressionLastElement((int)n, (int)0, (int)-2);
        if (n2 <= i) {
            while (true) {
                int digit;
                checksum += (digit = (sanitizedCardNumber.charAt(i) - 48) * 2) > 9 ? digit - 9 : digit;
                if (i == n2) break;
                i -= 2;
            }
        }
        return checksum % 10 == 0;
    }

    public final boolean isCardExpiryDateValid(@NotNull String enteredDate) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)enteredDate, (String)"enteredDate");
        String[] stringArray = new String[]{"/"};
        List parts = StringsKt.split$default((CharSequence)enteredDate, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (parts.size() != 2) {
            return false;
        }
        Integer month = StringsKt.toIntOrNull((String)((String)parts.get(0)));
        Integer year = StringsKt.toIntOrNull((String)((String)parts.get(1)));
        if (month == null || year == null) {
            return false;
        }
        if (month < 1 || month > 12) {
            return false;
        }
        int currentYear = TimeZoneKt.toLocalDateTime((Instant)Clock.System.INSTANCE.now(), (TimeZone)TimeZone.Companion.currentSystemDefault()).getYear();
        int currentMonth = TimeZoneKt.toLocalDateTime((Instant)Clock.System.INSTANCE.now(), (TimeZone)TimeZone.Companion.currentSystemDefault()).getMonthNumber();
        if (year < currentYear % 100) {
            bl = false;
        } else {
            int n = currentYear % 100;
            bl = year != n || month >= currentMonth;
        }
        return bl;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CardType.values().length];
            try {
                nArray[CardType.AMEX.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardType.VERVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardType.MAESTRO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardType.JCB.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardType.DINERS_CLUB.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardType.UNKNOWN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

