/*
 * Decompiled with CFR 0.152.
 */
package com.paystack.android.ui.paymentchannels.mobilemoney.mpesa;

import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.ViewModelStoreOwner;
import com.paystack.android.core.api.models.AccessCodeData;
import com.paystack.android.core.api.models.PaystackError;
import com.paystack.android.core.api.models.TransactionEvent;
import com.paystack.android.core.api.models.TransactionStatus;
import com.paystack.android.core.logging.Logger;
import com.paystack.android.ui.R;
import com.paystack.android.ui.data.transaction.TransactionRepository;
import com.paystack.android.ui.models.Charge;
import com.paystack.android.ui.models.MobileMoneyCharge;
import com.paystack.android.ui.paymentchannels.mobilemoney.mpesa.MpesaPaymentState;
import com.paystack.android.ui.paymentchannels.mobilemoney.mpesa.MpesaViewModel;
import com.paystack.android.ui.paymentchannels.mobilemoney.mpesa.numberform.MpesaNumberFormState;
import com.paystack.android.ui.utilities.CountdownTimer;
import com.paystack.android.ui.utilities.CurrencyFormatter;
import com.paystack.android.ui.utilities.PaystackErrorExtKt;
import com.paystack.android.ui.utilities.StringProvider;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 Z2\u00020\u0001:\u0001ZBW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0\t\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u001a\u00104\u001a\u00020\u000b2\b\u00105\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0006\u00106\u001a\u00020\u000bJ\b\u00107\u001a\u00020\u000bH\u0002J\b\u00108\u001a\u00020\u0005H\u0002J\u0010\u00109\u001a\u00020\u000b2\u0006\u0010:\u001a\u00020\rH\u0002J\u0010\u0010;\u001a\u00020\u000b2\u0006\u0010<\u001a\u00020=H\u0002J\u0012\u0010>\u001a\u00020\u000b2\b\u0010?\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010@\u001a\u00020\u00192\u0006\u0010A\u001a\u00020\u0005H\u0002J$\u0010B\u001a\u00020\u000b2\u0006\u0010C\u001a\u00020\u00052\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u00020E\u0012\u0004\u0012\u00020\u000b0\tH\u0002J\u000e\u0010F\u001a\u00020\u000b2\u0006\u00105\u001a\u00020\u0005J\u0006\u0010G\u001a\u00020\u000bJ\u0006\u0010H\u001a\u00020\u000bJ\u001e\u0010I\u001a\u00020\u000b2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020=0KH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010LJ\b\u0010M\u001a\u00020\u000bH\u0002J\u0006\u0010N\u001a\u00020\u000bJ\u0006\u0010O\u001a\u00020\u000bJ\u0006\u0010P\u001a\u00020\u000bJ\u0006\u0010Q\u001a\u00020\u000bJ\u0006\u0010R\u001a\u00020\u000bJ\u0006\u0010S\u001a\u00020\u000bJ\b\u0010T\u001a\u00020\u000bH\u0002J\u0010\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020.H\u0002J\u0006\u0010X\u001a\u00020\u000bJ\u0006\u0010Y\u001a\u00020\u000bR\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001a\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020&0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00150(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0017\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00170(\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010*R\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u00100\u001a\b\u0012\u0004\u0012\u00020\u00190(\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010*R\u0017\u00102\u001a\b\u0012\u0004\u0012\u00020\u00190(\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010*R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006["}, d2={"Lcom/paystack/android/ui/paymentchannels/mobilemoney/mpesa/MpesaViewModel;", "Landroidx/lifecycle/ViewModel;", "accessCodeData", "Lcom/paystack/android/core/api/models/AccessCodeData;", "providerKey", "", "transactionRepository", "Lcom/paystack/android/ui/data/transaction/TransactionRepository;", "onPaymentComplete", "Lkotlin/Function1;", "Lcom/paystack/android/ui/models/Charge;", "", "onError", "", "stringProvider", "Lcom/paystack/android/ui/utilities/StringProvider;", "countdownDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Lcom/paystack/android/core/api/models/AccessCodeData;Ljava/lang/String;Lcom/paystack/android/ui/data/transaction/TransactionRepository;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lcom/paystack/android/ui/utilities/StringProvider;Lkotlinx/coroutines/CoroutineDispatcher;)V", "_mpesaPaymentsState", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/paystack/android/ui/paymentchannels/mobilemoney/mpesa/MpesaPaymentState;", "_numberFormUiState", "Lcom/paystack/android/ui/paymentchannels/mobilemoney/mpesa/numberform/MpesaNumberFormState;", "_showAccountNumberCopyIcon", "", "_showPaybillNumberCopyIcon", "accountNumber", "amount", "getAmount", "()Ljava/lang/String;", "isOfflineState", "mpesaFlowViewModelStoreOwner", "Landroidx/lifecycle/ViewModelStoreOwner;", "getMpesaFlowViewModelStoreOwner", "()Landroidx/lifecycle/ViewModelStoreOwner;", "mpesaFlowViewModelStores", "", "Landroidx/lifecycle/ViewModelStore;", "mpesaPaymentsState", "Lkotlinx/coroutines/flow/StateFlow;", "getMpesaPaymentsState", "()Lkotlinx/coroutines/flow/StateFlow;", "numberFormUiState", "getNumberFormUiState", "offlineRequeryCounter", "", "paybillNumber", "showAccountNumberCopyIcon", "getShowAccountNumberCopyIcon", "showPaybillNumberCopyIcon", "getShowPaybillNumberCopyIcon", "chargeMoney", "phoneNumber", "checkOfflinePaymentStatus", "checkPaymentStatus", "formatPhoneNumber", "handleFailure", "error", "handleSuccessResult", "chargeResult", "Lcom/paystack/android/ui/models/MobileMoneyCharge;", "handleTransactionEventFailure", "message", "isFormattedPhoneNumberValid", "formattedPhoneNumber", "observeTransactionEvent", "channelName", "onEvent", "Lcom/paystack/android/core/api/models/TransactionEvent;", "onPhoneNumberChanged", "payOffline", "payOnline", "processResult", "result", "Lkotlin/Result;", "(Ljava/lang/Object;)V", "resetNumberFormUiState", "retryPayOffline", "retrySameNumber", "showOfflineDetails", "showPayWithLipaSteps", "startCopyAccountNumberCountdownTimer", "startCopyPaybillNumberCountdownTimer", "startOfflineRequeryDelay", "startRequeryDelayTimer", "Lkotlinx/coroutines/Job;", "delayTimeMs", "switchToOnline", "validatePhoneNumber", "Companion", "paystack-ui_release"})
@SourceDebugExtension(value={"SMAP\nMpesaViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MpesaViewModel.kt\ncom/paystack/android/ui/paymentchannels/mobilemoney/mpesa/MpesaViewModel\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,384:1\n230#2,5:385\n230#2,5:390\n230#2,5:395\n230#2,5:400\n230#2,5:405\n230#2,5:410\n230#2,5:416\n230#2,5:421\n1#3:415\n*S KotlinDebug\n*F\n+ 1 MpesaViewModel.kt\ncom/paystack/android/ui/paymentchannels/mobilemoney/mpesa/MpesaViewModel\n*L\n94#1:385,5\n101#1:390,5\n102#1:395,5\n103#1:400,5\n130#1:405,5\n144#1:410,5\n210#1:416,5\n218#1:421,5\n*E\n"})
public final class MpesaViewModel
extends ViewModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AccessCodeData accessCodeData;
    @NotNull
    private final String providerKey;
    @NotNull
    private final TransactionRepository transactionRepository;
    @NotNull
    private final Function1<Charge, Unit> onPaymentComplete;
    @NotNull
    private final Function1<Throwable, Unit> onError;
    @NotNull
    private final StringProvider stringProvider;
    @NotNull
    private final CoroutineDispatcher countdownDispatcher;
    @NotNull
    private final MutableStateFlow<MpesaPaymentState> _mpesaPaymentsState;
    @NotNull
    private final Map<String, ViewModelStore> mpesaFlowViewModelStores;
    @NotNull
    private final ViewModelStoreOwner mpesaFlowViewModelStoreOwner;
    @NotNull
    private final MutableStateFlow<MpesaNumberFormState> _numberFormUiState;
    @NotNull
    private final StateFlow<MpesaNumberFormState> numberFormUiState;
    @NotNull
    private final MutableStateFlow<String> paybillNumber;
    @NotNull
    private final MutableStateFlow<String> accountNumber;
    @NotNull
    private final MutableStateFlow<Boolean> isOfflineState;
    @NotNull
    private final MutableStateFlow<Integer> offlineRequeryCounter;
    @NotNull
    private final MutableStateFlow<Boolean> _showPaybillNumberCopyIcon;
    @NotNull
    private final StateFlow<Boolean> showPaybillNumberCopyIcon;
    @NotNull
    private final MutableStateFlow<Boolean> _showAccountNumberCopyIcon;
    @NotNull
    private final StateFlow<Boolean> showAccountNumberCopyIcon;
    @NotNull
    public static final String KEY_MPESA_OFFLINE = "MPESA_OFF";
    @NotNull
    private static final String KE_DIALING_CODE = "+254";
    private static final int KE_STANDARD_PHONE_NUMBER_SUFFIX_LENGTH = 9;
    private static final int KE_STANDARD_PHONE_NUMBER_FULL_LENGTH = 13;
    private static final int TEXT_COPY_DURATION = 5000;
    private static final long OFFLINE_REQUERY_DELAY_MS = 5000L;
    private static final int OFFLINE_REQUERY_MAX_COUNT = 12;
    private static final int OFFLINE_REQUERY_INIT_COUNT = 0;
    private static final int OFFLINE_REQUERY_COUNT_INCREMENTER = 1;

    public MpesaViewModel(@NotNull AccessCodeData accessCodeData, @NotNull String providerKey, @NotNull TransactionRepository transactionRepository, @NotNull Function1<? super Charge, Unit> onPaymentComplete, @NotNull Function1<? super Throwable, Unit> onError, @NotNull StringProvider stringProvider, @NotNull CoroutineDispatcher countdownDispatcher) {
        Intrinsics.checkNotNullParameter((Object)accessCodeData, (String)"accessCodeData");
        Intrinsics.checkNotNullParameter((Object)providerKey, (String)"providerKey");
        Intrinsics.checkNotNullParameter((Object)transactionRepository, (String)"transactionRepository");
        Intrinsics.checkNotNullParameter(onPaymentComplete, (String)"onPaymentComplete");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        Intrinsics.checkNotNullParameter((Object)stringProvider, (String)"stringProvider");
        Intrinsics.checkNotNullParameter((Object)countdownDispatcher, (String)"countdownDispatcher");
        this.accessCodeData = accessCodeData;
        this.providerKey = providerKey;
        this.transactionRepository = transactionRepository;
        this.onPaymentComplete = onPaymentComplete;
        this.onError = onError;
        this.stringProvider = stringProvider;
        this.countdownDispatcher = countdownDispatcher;
        this._mpesaPaymentsState = StateFlowKt.MutableStateFlow((Object)MpesaPaymentState.EnterNumber.INSTANCE);
        this.mpesaFlowViewModelStores = new LinkedHashMap();
        this.mpesaFlowViewModelStoreOwner = new ViewModelStoreOwner(this){
            final /* synthetic */ MpesaViewModel this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public ViewModelStore getViewModelStore() {
                String string2 = MpesaViewModel.access$get_mpesaPaymentsState$p(this.this$0).getValue().getClass().getCanonicalName();
                if (string2 == null) {
                    mpesaFlowViewModelStoreOwner.1 var2_1 = this;
                    MpesaViewModel mpesaViewModel = this.this$0;
                    mpesaFlowViewModelStoreOwner.1 $this$_get_viewModelStore__u24lambda_u240 = var2_1;
                    boolean bl = false;
                    Logger.INSTANCE.error("Unable to get name for " + MpesaViewModel.access$get_mpesaPaymentsState$p(mpesaViewModel).getValue().getClass());
                    return new ViewModelStore();
                }
                String key = string2;
                ViewModelStore viewModelStore = (ViewModelStore)MpesaViewModel.access$getMpesaFlowViewModelStores$p(this.this$0).get(key);
                if (viewModelStore == null) {
                    mpesaFlowViewModelStoreOwner.1 var2_2 = this;
                    MpesaViewModel mpesaViewModel = this.this$0;
                    mpesaFlowViewModelStoreOwner.1 $this$_get_viewModelStore__u24lambda_u241 = var2_2;
                    boolean bl = false;
                    ViewModelStore store = new ViewModelStore();
                    MpesaViewModel.access$getMpesaFlowViewModelStores$p(mpesaViewModel).put(key, store);
                    viewModelStore = store;
                }
                return viewModelStore;
            }
        };
        String string2 = this.providerKey;
        List list = this.accessCodeData.getChannelOptions().getMobileMoney();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List list2 = list;
        long l = this.accessCodeData.getAmount();
        String string3 = this.accessCodeData.getCurrency();
        this._numberFormUiState = StateFlowKt.MutableStateFlow((Object)new MpesaNumberFormState(l, string3, list2, string2, null, null, false, 112, null));
        this.numberFormUiState = FlowKt.asStateFlow(this._numberFormUiState);
        this.paybillNumber = StateFlowKt.MutableStateFlow((Object)"");
        this.accountNumber = StateFlowKt.MutableStateFlow((Object)"");
        this.isOfflineState = StateFlowKt.MutableStateFlow((Object)false);
        this.offlineRequeryCounter = StateFlowKt.MutableStateFlow((Object)0);
        this._showPaybillNumberCopyIcon = StateFlowKt.MutableStateFlow((Object)true);
        this.showPaybillNumberCopyIcon = FlowKt.asStateFlow(this._showPaybillNumberCopyIcon);
        this._showAccountNumberCopyIcon = StateFlowKt.MutableStateFlow((Object)true);
        this.showAccountNumberCopyIcon = FlowKt.asStateFlow(this._showAccountNumberCopyIcon);
    }

    public /* synthetic */ MpesaViewModel(AccessCodeData accessCodeData, String string2, TransactionRepository transactionRepository, Function1 function1, Function1 function12, StringProvider stringProvider, CoroutineDispatcher coroutineDispatcher, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            coroutineDispatcher = Dispatchers.getDefault();
        }
        this(accessCodeData, string2, transactionRepository, (Function1<? super Charge, Unit>)function1, (Function1<? super Throwable, Unit>)function12, stringProvider, coroutineDispatcher);
    }

    @NotNull
    public final StateFlow<MpesaPaymentState> getMpesaPaymentsState() {
        return (StateFlow)this._mpesaPaymentsState;
    }

    @NotNull
    public final ViewModelStoreOwner getMpesaFlowViewModelStoreOwner() {
        return this.mpesaFlowViewModelStoreOwner;
    }

    @NotNull
    public final StateFlow<MpesaNumberFormState> getNumberFormUiState() {
        return this.numberFormUiState;
    }

    @NotNull
    public final String getAmount() {
        return CurrencyFormatter.format$default(CurrencyFormatter.INSTANCE, this.accessCodeData.getAmount(), this.accessCodeData.getCurrency(), false, false, 12, null);
    }

    @NotNull
    public final StateFlow<Boolean> getShowPaybillNumberCopyIcon() {
        return this.showPaybillNumberCopyIcon;
    }

    @NotNull
    public final StateFlow<Boolean> getShowAccountNumberCopyIcon() {
        return this.showAccountNumberCopyIcon;
    }

    public final void onPhoneNumberChanged(@NotNull String phoneNumber) {
        MpesaNumberFormState it;
        MpesaNumberFormState nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter((Object)phoneNumber, (String)"phoneNumber");
        MutableStateFlow<MpesaNumberFormState> $this$update$iv = this._numberFormUiState;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (MpesaNumberFormState)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = MpesaNumberFormState.copy$default(it, 0L, null, null, null, phoneNumber, null, false, 111, null))));
    }

    public final void validatePhoneNumber() {
        if (((MpesaNumberFormState)this._numberFormUiState.getValue()).isPhoneNumberValid()) {
            String formattedPhoneNumber = this.formatPhoneNumber();
            if (!this.isFormattedPhoneNumberValid(formattedPhoneNumber)) {
                MpesaNumberFormState it;
                MpesaNumberFormState nextValue$iv;
                Object prevValue$iv;
                MutableStateFlow<MpesaNumberFormState> $this$update$iv = this._numberFormUiState;
                boolean $i$f$update = false;
                do {
                    prevValue$iv = $this$update$iv.getValue();
                    it = (MpesaNumberFormState)prevValue$iv;
                    boolean bl = false;
                } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = MpesaNumberFormState.copy$default(it, 0L, null, null, null, null, null, false, 95, null))));
            } else {
                MpesaNumberFormState it;
                MpesaNumberFormState nextValue$iv;
                Object prevValue$iv;
                MutableStateFlow<MpesaNumberFormState> $this$update$iv = this._numberFormUiState;
                boolean $i$f$update = false;
                do {
                    prevValue$iv = $this$update$iv.getValue();
                    it = (MpesaNumberFormState)prevValue$iv;
                    boolean bl = false;
                } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = MpesaNumberFormState.copy$default(it, 0L, null, null, null, null, formattedPhoneNumber, false, 95, null))));
            }
        } else {
            MpesaNumberFormState it;
            MpesaNumberFormState nextValue$iv;
            Object prevValue$iv;
            MutableStateFlow<MpesaNumberFormState> $this$update$iv = this._numberFormUiState;
            boolean $i$f$update = false;
            do {
                prevValue$iv = $this$update$iv.getValue();
                it = (MpesaNumberFormState)prevValue$iv;
                boolean bl = false;
            } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = MpesaNumberFormState.copy$default(it, 0L, null, null, null, null, null, false, 95, null))));
        }
    }

    private final String formatPhoneNumber() {
        String string2;
        int prefixLen = ((MpesaNumberFormState)this._numberFormUiState.getValue()).getPhoneNumber().length() - 9;
        String standardFormatPrefix = StringsKt.take((String)((MpesaNumberFormState)this._numberFormUiState.getValue()).getPhoneNumber(), (int)prefixLen);
        if (!Intrinsics.areEqual((Object)standardFormatPrefix, (Object)KE_DIALING_CODE)) {
            String string3 = ((MpesaNumberFormState)this._numberFormUiState.getValue()).getPhoneNumber();
            IntRange intRange = new IntRange(0, standardFormatPrefix.length() - 1);
            CharSequence charSequence = KE_DIALING_CODE;
            string2 = ((Object)StringsKt.replaceRange((CharSequence)string3, (IntRange)intRange, (CharSequence)charSequence)).toString();
        } else {
            string2 = ((MpesaNumberFormState)this._numberFormUiState.getValue()).getPhoneNumber();
        }
        return string2;
    }

    private final boolean isFormattedPhoneNumberValid(String formattedPhoneNumber) {
        return formattedPhoneNumber.length() == 13;
    }

    private final void resetNumberFormUiState() {
        MpesaNumberFormState it;
        MpesaNumberFormState nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<MpesaNumberFormState> $this$update$iv = this._numberFormUiState;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (MpesaNumberFormState)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = MpesaNumberFormState.copy$default(it, 0L, null, null, null, "", null, false, 47, null))));
    }

    private final void chargeMoney(String phoneNumber, String providerKey) {
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, providerKey, phoneNumber, null){
            int label;
            final /* synthetic */ MpesaViewModel this$0;
            final /* synthetic */ String $providerKey;
            final /* synthetic */ String $phoneNumber;
            {
                this.this$0 = $receiver;
                this.$providerKey = $providerKey;
                this.$phoneNumber = $phoneNumber;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = MpesaViewModel.access$getTransactionRepository$p(this.this$0).chargeMobileMoney-BWLJW6A(MpesaViewModel.access$getAccessCodeData$p(this.this$0).getId(), this.$providerKey, this.$phoneNumber, (Continuation<? super Result<MobileMoneyCharge>>)((Continuation)this));
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = ((Result)$result).unbox-impl();
lbl13:
                        // 2 sources

                        result = v0;
                        MpesaViewModel.access$processResult(this.this$0, result);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void payOnline() {
        MpesaNumberFormState it;
        MpesaNumberFormState nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<MpesaNumberFormState> $this$update$iv = this._numberFormUiState;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (MpesaNumberFormState)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = MpesaNumberFormState.copy$default(it, 0L, null, null, null, null, null, true, 63, null))));
        this.validatePhoneNumber();
        this.isOfflineState.setValue((Object)false);
        this.chargeMoney(((MpesaNumberFormState)this._numberFormUiState.getValue()).getFormattedPhoneNumber(), this.providerKey);
    }

    public final void payOffline() {
        this._mpesaPaymentsState.setValue((Object)new MpesaPaymentState.Loading(this.stringProvider.getString(R.string.pstk_mpesa_offline_switch_text)));
        this.isOfflineState.setValue((Object)true);
        this.chargeMoney(null, KEY_MPESA_OFFLINE);
    }

    private final void processResult(Object result) {
        block1: {
            Throwable throwable;
            Object object = result;
            if (Result.isSuccess-impl((Object)object)) {
                MobileMoneyCharge p0 = (MobileMoneyCharge)object;
                boolean bl = false;
                this.handleSuccessResult(p0);
            }
            Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
            if (throwable2 == null) break block1;
            Throwable p0 = throwable = throwable2;
            boolean bl = false;
            this.handleFailure(p0);
        }
    }

    private final void handleSuccessResult(MobileMoneyCharge chargeResult) {
        MobileMoneyCharge.Action action = chargeResult.getAction();
        if (action == null) {
            return;
        }
        MobileMoneyCharge.Action action2 = action;
        MobileMoneyCharge.Action action3 = action2;
        if (Intrinsics.areEqual((Object)action3, (Object)MobileMoneyCharge.Action.EnterNumber.INSTANCE)) {
            this._mpesaPaymentsState.setValue((Object)MpesaPaymentState.EnterNumber.INSTANCE);
        } else if (action3 instanceof MobileMoneyCharge.Action.ShowInstruction) {
            int requeryDelayMs = ((MobileMoneyCharge.Action.ShowInstruction)action2).getRequeryDelayMs();
            String string2 = ((MobileMoneyCharge.Action.ShowInstruction)action2).getInstruction();
            String string3 = chargeResult.getPhone();
            if (string3 == null) {
                string3 = "";
            }
            String string4 = string3;
            this._mpesaPaymentsState.setValue((Object)new MpesaPaymentState.InProgress(string2, string4, requeryDelayMs, requeryDelayMs));
            Job requeryTimerJob = this.startRequeryDelayTimer(requeryDelayMs);
            this.observeTransactionEvent(chargeResult.getChannelName(), (Function1<? super TransactionEvent, Unit>)((Function1)new Function1<TransactionEvent, Unit>(requeryTimerJob, this){
                final /* synthetic */ Job $requeryTimerJob;
                final /* synthetic */ MpesaViewModel this$0;
                {
                    this.$requeryTimerJob = $requeryTimerJob;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull TransactionEvent transactionEvent) {
                    Intrinsics.checkNotNullParameter((Object)transactionEvent, (String)"transactionEvent");
                    if (transactionEvent.getStatus() == TransactionStatus.Success) {
                        Job.DefaultImpls.cancel$default((Job)this.$requeryTimerJob, null, (int)1, null);
                        MpesaViewModel.access$checkPaymentStatus(this.this$0);
                    } else {
                        Job.DefaultImpls.cancel$default((Job)this.$requeryTimerJob, null, (int)1, null);
                        MpesaViewModel.access$handleTransactionEventFailure(this.this$0, transactionEvent.getMessage());
                    }
                }
            }));
        } else if (action3 instanceof MobileMoneyCharge.Action.ShowOfflineDetails) {
            String string5 = ((MobileMoneyCharge.Action.ShowOfflineDetails)action2).getPaybillNumber();
            if (string5 == null) {
                string5 = "";
            }
            this.paybillNumber.setValue((Object)string5);
            String string6 = ((MobileMoneyCharge.Action.ShowOfflineDetails)action2).getAccountNumber();
            if (string6 == null) {
                string6 = "";
            }
            this.accountNumber.setValue((Object)string6);
            this._mpesaPaymentsState.setValue((Object)new MpesaPaymentState.ShowOfflineDetails(this.getAmount(), (String)this.paybillNumber.getValue(), (String)this.accountNumber.getValue()));
            this.observeTransactionEvent(chargeResult.getChannelName(), (Function1<? super TransactionEvent, Unit>)((Function1)new Function1<TransactionEvent, Unit>(this){
                final /* synthetic */ MpesaViewModel this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull TransactionEvent transactionEvent) {
                    Intrinsics.checkNotNullParameter((Object)transactionEvent, (String)"transactionEvent");
                    if (transactionEvent.getStatus() == TransactionStatus.Success) {
                        MpesaViewModel.access$checkPaymentStatus(this.this$0);
                    } else {
                        MpesaViewModel.access$handleTransactionEventFailure(this.this$0, transactionEvent.getMessage());
                    }
                }
            }));
        }
    }

    private final void handleFailure(Throwable error) {
        MpesaPaymentState mpesaPaymentState;
        MpesaPaymentState nextValue$iv;
        Object prevValue$iv;
        String string2 = error.getMessage();
        if (string2 == null) {
            string2 = "";
        }
        Logger.INSTANCE.error(error, string2);
        if (error instanceof PaystackError && !PaystackErrorExtKt.isFatal((PaystackError)error)) {
            MpesaPaymentState mpesaPaymentState2;
            MpesaPaymentState nextValue$iv2;
            Object prevValue$iv2;
            MutableStateFlow<MpesaPaymentState> $this$update$iv = this._mpesaPaymentsState;
            boolean $i$f$update = false;
            do {
                prevValue$iv2 = $this$update$iv.getValue();
                MpesaPaymentState it = (MpesaPaymentState)prevValue$iv2;
                boolean bl = false;
                if (((Boolean)this.isOfflineState.getValue()).booleanValue()) {
                    mpesaPaymentState2 = new MpesaPaymentState.OfflineError(((PaystackError)error).getMessage(), false, 2, null);
                    continue;
                }
                mpesaPaymentState2 = new MpesaPaymentState.Error(((PaystackError)error).getMessage());
            } while (!$this$update$iv.compareAndSet(prevValue$iv2, (Object)(nextValue$iv2 = mpesaPaymentState2)));
            return;
        }
        String message = this.stringProvider.getString(R.string.pstk_generic_error_msg);
        MutableStateFlow<MpesaPaymentState> $this$update$iv = this._mpesaPaymentsState;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            MpesaPaymentState it = (MpesaPaymentState)prevValue$iv;
            boolean bl = false;
            if (((Boolean)this.isOfflineState.getValue()).booleanValue()) {
                mpesaPaymentState = new MpesaPaymentState.OfflineError(message, false, 2, null);
                continue;
            }
            mpesaPaymentState = new MpesaPaymentState.Error(message);
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = mpesaPaymentState)));
        this.onError.invoke((Object)error);
    }

    private final Job startRequeryDelayTimer(int delayTimeMs) {
        return BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), (CoroutineContext)((CoroutineContext)this.countdownDispatcher), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(delayTimeMs, this, null){
            int label;
            final /* synthetic */ int $delayTimeMs;
            final /* synthetic */ MpesaViewModel this$0;
            {
                this.$delayTimeMs = $delayTimeMs;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = FlowKt.collectLatest((Flow)CountdownTimer.start$default(new CountdownTimer(), this.$delayTimeMs, 0, 2, null), (Function2)((Function2)new Function2<Integer, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ int I$0;
                            final /* synthetic */ MpesaViewModel this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        int remainingTimeMs = this.I$0;
                                        MpesaPaymentState state = (MpesaPaymentState)MpesaViewModel.access$get_mpesaPaymentsState$p(this.this$0).getValue();
                                        if (state instanceof MpesaPaymentState.InProgress) {
                                            MpesaViewModel.access$get_mpesaPaymentsState$p(this.this$0).setValue((Object)MpesaPaymentState.InProgress.copy$default((MpesaPaymentState.InProgress)state, null, null, 0, remainingTimeMs, 7, null));
                                            if (remainingTimeMs == 0) {
                                                MpesaViewModel.access$checkPaymentStatus(this.this$0);
                                            }
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.I$0 = ((Number)value).intValue();
                                return (Continuation)var3_3;
                            }

                            @Nullable
                            public final Object invoke(int p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void checkPaymentStatus() {
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ MpesaViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var12_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        MpesaViewModel.access$get_mpesaPaymentsState$p(this.this$0).setValue((Object)MpesaPaymentState.VerifyingPayment.INSTANCE);
                        this.label = 1;
                        v0 = MpesaViewModel.access$getTransactionRepository$p(this.this$0).checkPendingCharge-gIAlu-s(MpesaViewModel.access$getAccessCodeData$p(this.this$0).getAccessCode(), (Continuation<? super Result<Charge>>)((Continuation)this));
                        if (v0 == var12_2) {
                            return var12_2;
                        }
                        ** GOTO lbl14
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = ((Result)$result).unbox-impl();
lbl14:
                        // 2 sources

                        var2_3 = v0;
                        var3_4 = this.this$0;
                        v1 = Result.exceptionOrNull-impl((Object)var2_3);
                        if (v1 != null) {
                            p0 = var4_5 = v1;
                            $i$a$-onFailure-MpesaViewModel$checkPaymentStatus$1$1 = false;
                            MpesaViewModel.access$handleFailure(var3_4, p0);
                        }
                        var3_4 = this.this$0;
                        if (Result.isSuccess-impl((Object)var2_3)) {
                            charge = (Charge)var2_3;
                            $i$a$-onSuccess-MpesaViewModel$checkPaymentStatus$1$2 = false;
                            switch (checkPaymentStatus.WhenMappings.$EnumSwitchMapping$0[charge.getStatus().ordinal()]) {
                                case 1: {
                                    MpesaViewModel.access$getOnPaymentComplete$p(var3_4).invoke((Object)charge);
                                    break;
                                }
                                case 2: {
                                    MpesaViewModel.access$startOfflineRequeryDelay(var3_4);
                                    break;
                                }
                                case 3: {
                                    v2 = charge.getMessage();
                                    if (v2 == null) {
                                        v2 = MpesaViewModel.access$getStringProvider$p(var3_4).getString(R.string.pstk_mpesa_payment_generic_error_message);
                                    }
                                    errorMessage = v2;
                                    $this$update$iv = MpesaViewModel.access$get_mpesaPaymentsState$p(var3_4);
                                    $i$f$update = false;
                                    do {
                                        prevValue$iv = $this$update$iv.getValue();
                                        (MpesaPaymentState)prevValue$iv;
                                        $i$a$-update-MpesaViewModel$checkPaymentStatus$1$2$1 = false;
                                        if (((Boolean)MpesaViewModel.access$isOfflineState$p(var3_4).getValue()).booleanValue()) {
                                            v3 = new MpesaPaymentState.OfflineError(errorMessage, false, 2, null);
                                            continue;
                                        }
                                        v3 = new MpesaPaymentState.Error(errorMessage);
                                    } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = v3)));
                                    break;
                                }
                                default: {
                                    errorMessage = MpesaViewModel.access$getStringProvider$p(var3_4).getString(R.string.pstk_mpesa_payment_generic_error_message);
                                    $this$update$iv = MpesaViewModel.access$get_mpesaPaymentsState$p(var3_4);
                                    $i$f$update = false;
                                    do {
                                        prevValue$iv = $this$update$iv.getValue();
                                        (MpesaPaymentState)prevValue$iv;
                                        $i$a$-update-MpesaViewModel$checkPaymentStatus$1$2$2 = false;
                                        if (((Boolean)MpesaViewModel.access$isOfflineState$p(var3_4).getValue()).booleanValue()) {
                                            v4 = new MpesaPaymentState.OfflineError(errorMessage, false, 2, null);
                                            continue;
                                        }
                                        v4 = new MpesaPaymentState.Error(errorMessage);
                                    } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = v4)));
                                }
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void observeTransactionEvent(String channelName, Function1<? super TransactionEvent, Unit> onEvent) {
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, channelName, onEvent, null){
            int label;
            final /* synthetic */ MpesaViewModel this$0;
            final /* synthetic */ String $channelName;
            final /* synthetic */ Function1<TransactionEvent, Unit> $onEvent;
            {
                this.this$0 = $receiver;
                this.$channelName = $channelName;
                this.$onEvent = $onEvent;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = MpesaViewModel.access$getTransactionRepository$p(this.this$0).awaitTransactionEvent-gIAlu-s(this.$channelName, (Continuation<? super Result<TransactionEvent>>)((Continuation)this));
                        if (v0 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = ((Result)$result).unbox-impl();
lbl13:
                        // 2 sources

                        var3_4 = result = v0;
                        var4_5 = this.this$0;
                        v1 = Result.exceptionOrNull-impl((Object)var3_4);
                        if (v1 != null) {
                            p0 = var5_6 = v1;
                            $i$a$-onFailure-MpesaViewModel$observeTransactionEvent$1$1 = false;
                            MpesaViewModel.access$handleFailure(var4_5, p0);
                        }
                        var4_5 = this.$onEvent;
                        if (Result.isSuccess-impl((Object)var3_4)) {
                            var4_5.invoke(var3_4);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void handleTransactionEventFailure(String message) {
        String errorMessage;
        String string2 = message;
        if (string2 == null) {
            string2 = errorMessage = this.stringProvider.getString(R.string.pstk_mpesa_payment_generic_error_message);
        }
        if (((Boolean)this.isOfflineState.getValue()).booleanValue()) {
            this._mpesaPaymentsState.setValue((Object)new MpesaPaymentState.OfflineError(errorMessage, false, 2, null));
        } else {
            this._mpesaPaymentsState.setValue((Object)new MpesaPaymentState.Error(errorMessage));
        }
    }

    private final void startOfflineRequeryDelay() {
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ MpesaViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = DelayKt.delay((long)5000L, (Continuation)((Continuation)this));
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if ((state = (MpesaPaymentState)MpesaViewModel.access$get_mpesaPaymentsState$p(this.this$0).getValue()) instanceof MpesaPaymentState.VerifyingPayment) {
                            if (((Number)MpesaViewModel.access$getOfflineRequeryCounter$p(this.this$0).getValue()).intValue() == 12) {
                                MpesaViewModel.access$get_mpesaPaymentsState$p(this.this$0).setValue((Object)new MpesaPaymentState.OfflineError(MpesaViewModel.access$getStringProvider$p(this.this$0).getString(R.string.pstk_mpesa_offline_requery_error_message), true));
                                MpesaViewModel.access$getOfflineRequeryCounter$p(this.this$0).setValue((Object)Boxing.boxInt((int)0));
                            } else {
                                var3_4 = MpesaViewModel.access$getOfflineRequeryCounter$p(this.this$0);
                                var3_4.setValue((Object)Boxing.boxInt((int)(((Number)var3_4.getValue()).intValue() + 1)));
                                MpesaViewModel.access$checkPaymentStatus(this.this$0);
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void showPayWithLipaSteps() {
        this._mpesaPaymentsState.setValue((Object)MpesaPaymentState.ShowPayWithLipaSteps.INSTANCE);
    }

    public final void showOfflineDetails() {
        this._mpesaPaymentsState.setValue((Object)new MpesaPaymentState.ShowOfflineDetails(this.getAmount(), (String)this.paybillNumber.getValue(), (String)this.accountNumber.getValue()));
    }

    public final void checkOfflinePaymentStatus() {
        this.checkPaymentStatus();
    }

    public final void retrySameNumber() {
        this._mpesaPaymentsState.setValue((Object)new MpesaPaymentState.Loading(null, 1, null));
        this.isOfflineState.setValue((Object)false);
        this.chargeMoney(((MpesaNumberFormState)this._numberFormUiState.getValue()).getFormattedPhoneNumber(), this.providerKey);
    }

    public final void switchToOnline() {
        this.resetNumberFormUiState();
        this.isOfflineState.setValue((Object)false);
        this._mpesaPaymentsState.setValue((Object)MpesaPaymentState.EnterNumber.INSTANCE);
    }

    public final void startCopyPaybillNumberCountdownTimer() {
        this._showPaybillNumberCopyIcon.setValue((Object)false);
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), (CoroutineContext)((CoroutineContext)this.countdownDispatcher), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ MpesaViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = FlowKt.collectLatest((Flow)CountdownTimer.start$default(new CountdownTimer(), 5000, 0, 2, null), (Function2)((Function2)new Function2<Integer, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ int I$0;
                            final /* synthetic */ MpesaViewModel this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        int remainingTimeMs = this.I$0;
                                        MpesaPaymentState state = (MpesaPaymentState)MpesaViewModel.access$get_mpesaPaymentsState$p(this.this$0).getValue();
                                        if (state instanceof MpesaPaymentState.ShowOfflineDetails && remainingTimeMs == 0) {
                                            MpesaViewModel.access$get_showPaybillNumberCopyIcon$p(this.this$0).setValue((Object)Boxing.boxBoolean((boolean)true));
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.I$0 = ((Number)value).intValue();
                                return (Continuation)var3_3;
                            }

                            @Nullable
                            public final Object invoke(int p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void startCopyAccountNumberCountdownTimer() {
        this._showAccountNumberCopyIcon.setValue((Object)false);
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), (CoroutineContext)((CoroutineContext)this.countdownDispatcher), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ MpesaViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = FlowKt.collectLatest((Flow)CountdownTimer.start$default(new CountdownTimer(), 5000, 0, 2, null), (Function2)((Function2)new Function2<Integer, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ int I$0;
                            final /* synthetic */ MpesaViewModel this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        int remainingTimeMs = this.I$0;
                                        MpesaPaymentState state = (MpesaPaymentState)MpesaViewModel.access$get_mpesaPaymentsState$p(this.this$0).getValue();
                                        if (state instanceof MpesaPaymentState.ShowOfflineDetails && remainingTimeMs == 0) {
                                            MpesaViewModel.access$get_showAccountNumberCopyIcon$p(this.this$0).setValue((Object)Boxing.boxBoolean((boolean)true));
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.I$0 = ((Number)value).intValue();
                                return (Continuation)var3_3;
                            }

                            @Nullable
                            public final Object invoke(int p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void retryPayOffline() {
        this._mpesaPaymentsState.setValue((Object)new MpesaPaymentState.Loading(this.stringProvider.getString(R.string.pstk_mpesa_offline_retry_payment_text)));
        this.isOfflineState.setValue((Object)true);
        this.chargeMoney(null, KEY_MPESA_OFFLINE);
    }

    public static final /* synthetic */ TransactionRepository access$getTransactionRepository$p(MpesaViewModel $this) {
        return $this.transactionRepository;
    }

    public static final /* synthetic */ AccessCodeData access$getAccessCodeData$p(MpesaViewModel $this) {
        return $this.accessCodeData;
    }

    public static final /* synthetic */ void access$processResult(MpesaViewModel $this, Object result) {
        $this.processResult(result);
    }

    public static final /* synthetic */ void access$checkPaymentStatus(MpesaViewModel $this) {
        $this.checkPaymentStatus();
    }

    public static final /* synthetic */ void access$handleTransactionEventFailure(MpesaViewModel $this, String message) {
        $this.handleTransactionEventFailure(message);
    }

    public static final /* synthetic */ MutableStateFlow access$get_mpesaPaymentsState$p(MpesaViewModel $this) {
        return $this._mpesaPaymentsState;
    }

    public static final /* synthetic */ void access$handleFailure(MpesaViewModel $this, Throwable error) {
        $this.handleFailure(error);
    }

    public static final /* synthetic */ MutableStateFlow access$isOfflineState$p(MpesaViewModel $this) {
        return $this.isOfflineState;
    }

    public static final /* synthetic */ Function1 access$getOnPaymentComplete$p(MpesaViewModel $this) {
        return $this.onPaymentComplete;
    }

    public static final /* synthetic */ void access$startOfflineRequeryDelay(MpesaViewModel $this) {
        $this.startOfflineRequeryDelay();
    }

    public static final /* synthetic */ StringProvider access$getStringProvider$p(MpesaViewModel $this) {
        return $this.stringProvider;
    }

    public static final /* synthetic */ MutableStateFlow access$getOfflineRequeryCounter$p(MpesaViewModel $this) {
        return $this.offlineRequeryCounter;
    }

    public static final /* synthetic */ MutableStateFlow access$get_showPaybillNumberCopyIcon$p(MpesaViewModel $this) {
        return $this._showPaybillNumberCopyIcon;
    }

    public static final /* synthetic */ MutableStateFlow access$get_showAccountNumberCopyIcon$p(MpesaViewModel $this) {
        return $this._showAccountNumberCopyIcon;
    }

    public static final /* synthetic */ Map access$getMpesaFlowViewModelStores$p(MpesaViewModel $this) {
        return $this.mpesaFlowViewModelStores;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/paystack/android/ui/paymentchannels/mobilemoney/mpesa/MpesaViewModel$Companion;", "", "()V", "KEY_MPESA_OFFLINE", "", "KE_DIALING_CODE", "KE_STANDARD_PHONE_NUMBER_FULL_LENGTH", "", "KE_STANDARD_PHONE_NUMBER_SUFFIX_LENGTH", "OFFLINE_REQUERY_COUNT_INCREMENTER", "OFFLINE_REQUERY_DELAY_MS", "", "OFFLINE_REQUERY_INIT_COUNT", "OFFLINE_REQUERY_MAX_COUNT", "TEXT_COPY_DURATION", "paystack-ui_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

