@file:Suppress("LongParameterList")
package com.paystack.android.ui.theme.colors

import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.setValue
import androidx.compose.runtime.staticCompositionLocalOf

internal class PaystackColors(
    primaryColors: PrimaryColors,
    secondaryColors: SecondaryColors,
    neutralColors: NeutralColors,
    feedbackColors: FeedbackColors
) {
    var primaryColors by mutableStateOf(primaryColors)
        private set
    var secondaryColors by mutableStateOf(secondaryColors)
        private set
    var neutralColors by mutableStateOf(neutralColors)
        private set

    var feedbackColors by mutableStateOf(feedbackColors)
        private set

    fun copy(
        primaryColors: PrimaryColors = this.primaryColors.copy(),
        secondaryColors: SecondaryColors = this.secondaryColors.copy(),
        neutralColors: NeutralColors = this.neutralColors.copy(),
        feedbackColors: FeedbackColors = this.feedbackColors.copy()

    ): PaystackColors = PaystackColors(
        primaryColors,
        secondaryColors,
        neutralColors,
        feedbackColors
    )

    fun updateColorsFrom(other: PaystackColors) {
        primaryColors.updateColorsFrom(other.primaryColors)
        secondaryColors.updateColorsFrom(other.secondaryColors)
        neutralColors.updateColorsFrom(other.neutralColors)
        feedbackColors.updateColorsFrom(other.feedbackColors)
    }
}

internal fun lightColors(
    primaryColors: PrimaryColors = lightPrimaryColors(),
    secondaryColors: SecondaryColors = lightSecondaryColors(),
    neutralColors: NeutralColors = lightNeutralColors(),
    feedbackColors: FeedbackColors = lightFeedbackColors()
): PaystackColors = PaystackColors(
    primaryColors,
    secondaryColors,
    neutralColors,
    feedbackColors
)

internal val LocalColors = staticCompositionLocalOf { lightColors() }
