@file:Suppress("LongParameterList")
package com.paystack.android.ui.theme.colors

import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.setValue
import androidx.compose.ui.graphics.Color

internal class NeutralColors(
    black: Color,
    grease: Color,
    charcoal: Color,
    gray01: Color,
    gray02: Color,
    silver: Color,
    cloud: Color,
    white: Color
) {
    var black by mutableStateOf(black)
        private set
    var grease by mutableStateOf(grease)
        private set
    var charcoal by mutableStateOf(charcoal)
        private set
    var gray01 by mutableStateOf(gray01)
        private set
    var gray02 by mutableStateOf(gray02)
        private set
    var silver by mutableStateOf(silver)
        private set
    var cloud by mutableStateOf(cloud)
        private set
    var white by mutableStateOf(white)
        private set

    fun copy(
        black: Color = this.black,
        grease: Color = this.grease,
        charcoal: Color = this.charcoal,
        gray01: Color = this.gray01,
        gray02: Color = this.gray02,
        silver: Color = this.silver,
        cloud: Color = this.cloud,
        white: Color = this.white
    ): NeutralColors = NeutralColors(
        black,
        grease,
        charcoal,
        gray01,
        gray02,
        silver,
        cloud,
        white
    )

    fun updateColorsFrom(other: NeutralColors) {
        black = other.black
        grease = other.grease
        charcoal = other.charcoal
        gray01 = other.gray01
        gray02 = other.gray02
        silver = other.silver
        cloud = other.cloud
        white = other.white
    }
}

private val Black = Color(0xFF010B14)
private val Grease = Color(0xFF343C43)
private val Charcoal = Color(0xFF676D72)
private val Gray01 = Color(0xFF999DA1)
private val Gray02 = Color(0xFFCCCED0)
private val Silver = Color(0xFFE6E7E7)
private val Cloud = Color(0xFFF2F3F3)
private val White = Color(0xFFFFFFFF)

internal fun lightNeutralColors(
    black: Color = Black,
    grease: Color = Grease,
    charcoal: Color = Charcoal,
    gray01: Color = Gray01,
    gray02: Color = Gray02,
    silver: Color = Silver,
    cloud: Color = Cloud,
    white: Color = White
): NeutralColors = NeutralColors(
    black,
    grease,
    charcoal,
    gray01,
    gray02,
    silver,
    cloud,
    white
)
