@file:Suppress("LongParameterList")
package com.paystack.android.ui.theme.colors

import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.setValue
import androidx.compose.ui.graphics.Color

internal class FeedbackColors(

    // Error
    error01: Color,
    error02: Color,
    error03: Color,
    error04: Color,
    error05: Color,

    // Warning
    warning01: Color,
    warning02: Color,
    warning03: Color,
    warning04: Color,
    warning05: Color,

    // Information
    information01: Color,
    information02: Color,
    information03: Color,
    information04: Color,
    information05: Color,

    // Success
    success01: Color,
    success02: Color,
    success03: Color,
    success04: Color,
    success05: Color
) {

    var error01 by mutableStateOf(error01)
        private set
    var error02 by mutableStateOf(error02)
        private set
    var error03 by mutableStateOf(error03)
        private set
    var error04 by mutableStateOf(error04)
        private set
    var error05 by mutableStateOf(error05)
        private set

    var warning01 by mutableStateOf(warning01)
        private set
    var warning02 by mutableStateOf(warning02)
        private set
    var warning03 by mutableStateOf(warning03)
        private set
    var warning04 by mutableStateOf(warning04)
        private set
    var warning05 by mutableStateOf(warning05)
        private set

    var information01 by mutableStateOf(information01)
        private set
    var information02 by mutableStateOf(information02)
        private set
    var information03 by mutableStateOf(information03)
        private set
    var information04 by mutableStateOf(information04)
        private set
    var information05 by mutableStateOf(information05)
        private set

    var success01 by mutableStateOf(success01)
        private set
    var success02 by mutableStateOf(success02)
        private set
    var success03 by mutableStateOf(success03)
        private set
    var success04 by mutableStateOf(success04)
        private set
    var success05 by mutableStateOf(success05)
        private set

    fun copy(
        error01: Color = this.error01,
        error02: Color = this.error02,
        error03: Color = this.error03,
        error04: Color = this.error04,
        error05: Color = this.error05,

        warning01: Color = this.warning01,
        warning02: Color = this.warning02,
        warning03: Color = this.warning03,
        warning04: Color = this.warning04,
        warning05: Color = this.warning05,

        information01: Color = this.information01,
        information02: Color = this.information02,
        information03: Color = this.information03,
        information04: Color = this.information04,
        information05: Color = this.information05,

        success01: Color = this.success01,
        success02: Color = this.success02,
        success03: Color = this.success03,
        success04: Color = this.success04,
        success05: Color = this.success05

    ): FeedbackColors = FeedbackColors(

        error01,
        error02,
        error03,
        error04,
        error05,

        warning01,
        warning02,
        warning03,
        warning04,
        warning05,

        information01,
        information02,
        information03,
        information04,
        information05,

        success01,
        success02,
        success03,
        success04,
        success05
    )

    fun updateColorsFrom(other: FeedbackColors) {

        error01 = other.error01
        error02 = other.error02
        error03 = other.error03
        error04 = other.error04
        error05 = other.error05

        warning01 = other.warning01
        warning02 = other.warning02
        warning03 = other.warning03
        warning04 = other.warning04
        warning05 = other.warning05

        information01 = other.information01
        information02 = other.information02
        information03 = other.information03
        information04 = other.information04
        information05 = other.information05

        success01 = other.success01
        success02 = other.success02
        success03 = other.success03
        success04 = other.success04
        success05 = other.success05
    }
}

private val Error01 = Color(0xFF880202)
private val Error02 = Color(0xFFD44141)
private val Error03 = Color(0xFFF5A19C)
private val Error04 = Color(0xFFFBCBCB)
private val Error05 = Color(0xFFFFF1F1)

private val Warning01 = Color(0xFF673700)
private val Warning02 = Color(0xFFFFAA22)
private val Warning03 = Color(0xFFFFCC7A)
private val Warning04 = Color(0xFFFFE4B8)
private val Warning05 = Color(0xFFFFF6DF)

private val Information01 = Color(0xFF264E77)
private val Information02 = Color(0xFF4576C2)
private val Information03 = Color(0xFF6A91CE)
private val Information04 = Color(0xFFA2BBE0)
private val Information05 = Color(0xFFE1E9F5)

private val Success01 = Color(0xFF105843)
private val Success02 = Color(0xFF1A936F)
private val Success03 = Color(0xFF76BEA9)
private val Success04 = Color(0xFFBADFD4)
private val Success05 = Color(0xFFDDEFE9)

internal fun lightFeedbackColors(
    error01: Color = Error01,
    error02: Color = Error02,
    error03: Color = Error03,
    error04: Color = Error04,
    error05: Color = Error05,

    warning01: Color = Warning01,
    warning02: Color = Warning02,
    warning03: Color = Warning03,
    warning04: Color = Warning04,
    warning05: Color = Warning05,

    information01: Color = Information01,
    information02: Color = Information02,
    information03: Color = Information03,
    information04: Color = Information04,
    information05: Color = Information05,

    success01: Color = Success01,
    success02: Color = Success02,
    success03: Color = Success03,
    success04: Color = Success04,
    success05: Color = Success05
): FeedbackColors = FeedbackColors(
    error01,
    error02,
    error03,
    error04,
    error05,

    warning01,
    warning02,
    warning03,
    warning04,
    warning05,

    information01,
    information02,
    information03,
    information04,
    information05,

    success01,
    success02,
    success03,
    success04,
    success05
)
