package com.paystack.android.ui.theme

import android.app.Activity
import android.os.Build
import androidx.compose.foundation.isSystemInDarkTheme
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.dynamicDarkColorScheme
import androidx.compose.material3.dynamicLightColorScheme
import androidx.compose.runtime.Composable
import androidx.compose.runtime.ReadOnlyComposable
import androidx.compose.runtime.SideEffect
import androidx.compose.ui.graphics.toArgb
import androidx.compose.ui.platform.LocalContext
import androidx.compose.ui.platform.LocalView
import androidx.core.view.WindowCompat
import com.paystack.android.ui.theme.colors.LocalColors
import com.paystack.android.ui.theme.colors.PaystackColors
import com.paystack.android.ui.theme.dimensions.LocalDimensions
import com.paystack.android.ui.theme.dimensions.PaystackDimensions
import com.paystack.android.ui.theme.typography.LocalTypography
import com.paystack.android.ui.theme.typography.PaystackTypography

@Composable
internal fun PaystackTheme(
    useDarkTheme: Boolean = isSystemInDarkTheme(),
    content: @Composable () -> Unit,
) {
    val dynamicColor = Build.VERSION.SDK_INT >= Build.VERSION_CODES.S

    val payStackSampleColorScheme = when {
        dynamicColor && useDarkTheme -> dynamicDarkColorScheme(LocalContext.current)
        dynamicColor && !useDarkTheme -> dynamicLightColorScheme(LocalContext.current)
        useDarkTheme -> DarkColors
        else -> LightColors
    }

    val view = LocalView.current

    SideEffect {
        val window = (view.context as? Activity)?.window
        window?.statusBarColor = payStackSampleColorScheme.primary.toArgb()
        window?.let {
            WindowCompat.getInsetsController(window, view).isAppearanceLightStatusBars =
                useDarkTheme
        }
    }

    MaterialTheme(
        typography = Typography,
        colorScheme = payStackSampleColorScheme,
        content = content
    )
}

internal object PaystackTheme {
    val colors: PaystackColors
        @Composable
        @ReadOnlyComposable
        get() = LocalColors.current
    val typography: PaystackTypography
        @Composable
        @ReadOnlyComposable
        get() = LocalTypography.current
    val dimensions: PaystackDimensions
        @Composable
        @ReadOnlyComposable
        get() = LocalDimensions.current
}
