package com.paystack.android.ui.paymentchannels.mobilemoney.mpesa.paymenterror

import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.Surface
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.tooling.preview.Preview
import com.paystack.android.ui.R
import com.paystack.android.ui.components.PaymentErrorUi
import com.paystack.android.ui.components.buttons.PrimaryButton
import com.paystack.android.ui.components.buttons.SecondaryButton
import com.paystack.android.ui.theme.PaystackTheme

@Composable
internal fun MpesaOfflineErrorUi(
    message: String,
    isStatusRequery: Boolean,
    onPaymentCompleted: () -> Unit,
    onSwitchToOnline: () -> Unit,
    onRetryOffline: () -> Unit,
    modifier: Modifier = Modifier
) {
    Column(
        modifier = modifier
            .fillMaxWidth()
            .padding(PaystackTheme.dimensions.spacing.double),
        horizontalAlignment = Alignment.CenterHorizontally
    ) {
        PaymentErrorUi(
            message = message,
            modifier = modifier
        )

        Spacer(Modifier.height(PaystackTheme.dimensions.spacing.double))

        if (isStatusRequery) {
            PrimaryButton(
                buttonText = stringResource(R.string.pstk_mpesa_offline_completed_payment_button_text),
                onClick = onPaymentCompleted,
                isEnabled = true
            )

            Spacer(Modifier.height(PaystackTheme.dimensions.spacing.double))
        }

        SecondaryButton(
            text = stringResource(id = R.string.pstk_mpesa_retry_offline),
            onClick = onRetryOffline,
            modifier = Modifier.fillMaxWidth(),
            borderColor = PaystackTheme.colors.neutralColors.silver,
            contentColor = PaystackTheme.colors.primaryColors.navy01
        )

        Spacer(Modifier.height(PaystackTheme.dimensions.spacing.double))

        SecondaryButton(
            text = stringResource(id = R.string.pstk_switch_to_mpesa_express),
            onClick = onSwitchToOnline,
            modifier = Modifier.fillMaxWidth(),
            showBorder = false,
            contentColor = PaystackTheme.colors.primaryColors.navy01
        )
    }
}

@Preview
@Composable
private fun MpesaOfflineErrorUiPreview() {
    PaystackTheme {
        Surface(color = Color.White) {
            Column(Modifier.fillMaxSize()) {
                MpesaOfflineErrorUi(
                    "Your M-PESA balance is insufficient to complete this transaction.",
                    true,
                    {},
                    {},
                    {})
            }
        }
    }
}
