package com.paystack.android.ui.paymentchannels.mobilemoney.mpesa

internal sealed class MpesaPaymentState {
    object EnterNumber : MpesaPaymentState()
    data class InProgress(
        val instruction: String,
        val phoneNumber: String,
        val requeryDelayMs: Int,
        val timeLeftMs: Int
    ) : MpesaPaymentState()

    object VerifyingPayment : MpesaPaymentState()

    data class Error(val message: String) : MpesaPaymentState()

    data class Loading(val message: String? = null) : MpesaPaymentState()

    data class ShowOfflineDetails(
        val amount: String,
        val paybillNumber: String,
        val accountNumber: String
    ) : MpesaPaymentState()

    object ShowPayWithLipaSteps : MpesaPaymentState()

    data class OfflineError(val message: String, val isStatusRequery: Boolean = false) :
        MpesaPaymentState()
}
