package com.paystack.android.ui.paymentchannels.mobilemoney

import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.platform.LocalContext
import androidx.compose.ui.res.stringResource
import com.paystack.android.core.api.models.AccessCodeData
import com.paystack.android.ui.R
import com.paystack.android.ui.components.PaymentErrorUi
import com.paystack.android.ui.models.Charge
import com.paystack.android.ui.paymentchannels.mobilemoney.mpesa.MpesaScreen

@Composable
internal fun MobileMoneyScreen(
    accessCodeData: AccessCodeData,
    providerKey: String,
    onComplete: (Charge) -> Unit,
    onError: (Throwable) -> Unit,
    modifier: Modifier = Modifier
) {
    val context = LocalContext.current

    val viewModelsProviderFactory = MobileMoneyViewModelProviderFactory(
        context = context,
        transactionAccessData = accessCodeData,
        providerKey = providerKey,
        onPaymentComplete = onComplete,
        onError = onError
    )
    when (providerKey) {
        in SupportedMpesaProviderKeys -> MpesaScreen(
            viewModelsProviderFactory = viewModelsProviderFactory,
            modifier = modifier,
        )

        else -> PaymentErrorUi(
            message = stringResource(R.string.pstk_unsupported_payment_channel),
            modifier = modifier
        )
    }
}

val SupportedMpesaProviderKeys = listOf("MPESA")
