package com.paystack.android.ui.models

import android.os.Parcelable
import androidx.annotation.DrawableRes
import com.paystack.android.core.api.models.PaymentChannel
import kotlinx.parcelize.Parcelize

/**
 * Holds data for Payment channels displayed in [PaymentChannelUI]
 *
 * [providerKey] identifies the payment channel provider this object represents.
 * An example is M-Pesa as a mobile money provider.
 */
@Parcelize
internal data class PaymentChannelMenuItem(
    val paymentChannel: PaymentChannel,
    val providerKey: String,
    val name: String,
    @DrawableRes val iconRes: Int,
) : Parcelable
