package com.paystack.android.ui.components.views.inputs

import androidx.compose.foundation.text.KeyboardOptions
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.input.KeyboardType
import com.paystack.android.ui.R
import com.paystack.android.ui.components.views.inputs.textfield.StackTextField
import com.paystack.android.ui.components.views.inputs.validators.CardExpirationDateFormatter
import com.paystack.android.ui.theme.PaystackTheme

@Composable
internal fun CardExpiryInputField(
    modifier: Modifier = Modifier,
    expiryInputValue: String,
    isCardExpiryValid: Boolean = false,
    onDateTextChange: (String) -> Unit
) {
    val isError = !isCardExpiryValid && expiryInputValue.length >= DEFAULT_CARD_DATE_LENGTH
    StackTextField(
        modifier = modifier,
        value = expiryInputValue,
        onValueChange = { updatedExpiryDateValue ->
            if (updatedExpiryDateValue.length <= DEFAULT_CARD_DATE_LENGTH) {
                onDateTextChange(updatedExpiryDateValue)
            }
        },
        textStyle = PaystackTheme.typography.body.body16R,
        label = { Text(text = stringResource(id = R.string.pstk_card_payment_card_expiry_label)) },
        placeholder = { Text(text = stringResource(id = R.string.pstk_card_payment_card_expiry_placeholder)) },
        supportingText = {
            if (isError) {
                Text(text = stringResource(id = R.string.pstk_card_payment_card_expiry_error))
            }
        },
        isError = isError,
        keyboardOptions = KeyboardOptions.Default.copy(keyboardType = KeyboardType.Number),
        singleLine = true,
        visualTransformation = { updatedDateOfBirth ->
            onDateTextChange(updatedDateOfBirth.text)
            CardExpirationDateFormatter.formatEnteredCardDate(updatedDateOfBirth)
        }
    )
}

private const val DEFAULT_CARD_DATE_LENGTH = 4
