package com.paystack.android.ui.components.progressbars

import androidx.compose.material3.CircularProgressIndicator
import androidx.compose.material3.LocalContentColor
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.Dp
import com.paystack.android.ui.theme.PaystackTheme

@Composable
fun LoadingIndicator(
    modifier: Modifier = Modifier,
    color: Color = LocalContentColor.current,
    strokeWidth: Dp = PaystackTheme.dimensions.spacing.quarter
) {
    CircularProgressIndicator(
        color = color,
        modifier = modifier,
        strokeWidth = strokeWidth
    )
}
