package com.paystack.android.ui.components.buttons

import androidx.compose.foundation.BorderStroke
import androidx.compose.foundation.interaction.MutableInteractionSource
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.PaddingValues
import androidx.compose.foundation.layout.RowScope
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material3.ButtonColors
import androidx.compose.material3.ButtonDefaults
import androidx.compose.material3.ButtonElevation
import androidx.compose.material3.OutlinedButton
import androidx.compose.material3.ProvideTextStyle
import androidx.compose.material3.Surface
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.remember
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.Shape
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import com.paystack.android.ui.theme.PaystackTheme

@Composable
internal fun SecondaryButton(
    text: String,
    onClick: () -> Unit,
    modifier: Modifier = Modifier,
    enabled: Boolean = true,
    showBorder: Boolean = true,
    borderColor: Color = PaystackTheme.colors.secondaryColors.green02,
    contentColor: Color = PaystackTheme.colors.secondaryColors.green02
) {
    SecondaryButton(
        onClick = onClick,
        border = if (showBorder) BorderStroke(1.dp, borderColor) else null,
        colors = ButtonDefaults.outlinedButtonColors(contentColor = contentColor),
        modifier = modifier,
        enabled = enabled
    ) {
        ProvideTextStyle(value = PaystackTheme.typography.body.body16M) {
            Text(text = text)
        }
    }
}

@Composable
internal fun SecondaryButton(
    onClick: () -> Unit,
    border: BorderStroke?,
    colors: ButtonColors,
    modifier: Modifier = Modifier,
    enabled: Boolean = true,
    shape: Shape = RoundedCornerShape(PaystackTheme.dimensions.borderRadius.large),
    elevation: ButtonElevation? = null,
    contentPadding: PaddingValues = PaddingValues(
        horizontal = PaystackTheme.dimensions.spacing.double,
        vertical = PaystackTheme.dimensions.spacing.double
    ),
    interactionSource: MutableInteractionSource = remember { MutableInteractionSource() },
    content: @Composable RowScope.() -> Unit
) {
    OutlinedButton(
        onClick = onClick,
        modifier = modifier,
        enabled = enabled,
        shape = shape,
        colors = colors,
        elevation = elevation,
        border = border,
        contentPadding = contentPadding,
        interactionSource = interactionSource,
        content = content
    )
}

@Composable
@Preview
internal fun SecondaryButtonPreview() {
    PaystackTheme {
        Surface(modifier = Modifier.fillMaxSize()) {
            Box(contentAlignment = Alignment.Center) {
                SecondaryButton(text = "Try another card", onClick = {})
            }
        }
    }
}
