package com.paystack.android.ui.components

import androidx.compose.foundation.Image
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.Surface
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.tooling.preview.Preview
import com.paystack.android.ui.R
import com.paystack.android.ui.theme.PaystackTheme

@Composable
internal fun PaymentErrorUi(
    message: String,
    modifier: Modifier = Modifier,
    actionButton: @Composable (() -> Unit)? = null,
) {
    Column(
        modifier = modifier,
        horizontalAlignment = Alignment.CenterHorizontally,
    ) {
        Spacer(modifier = Modifier.height(PaystackTheme.dimensions.spacing.triple))

        Image(
            painter = painterResource(R.drawable.pstk_ic_warning),
            contentDescription = stringResource(R.string.pstk_error)
        )
        Spacer(modifier = Modifier.height(PaystackTheme.dimensions.spacing.double))

        Text(
            text = message,
            textAlign = TextAlign.Center,
            modifier = Modifier
                .padding(horizontal = PaystackTheme.dimensions.spacing.triple),
            style = PaystackTheme.typography.body.body16M,
        )

        Spacer(modifier = Modifier.height(PaystackTheme.dimensions.spacing.triple))

        actionButton?.let { it() }
    }
}

@Preview
@Composable
internal fun PaymentUiErrorPreview() {
    PaystackTheme {
        Surface {
            PaymentErrorUi(
                message = "Unsupported payment channel selected",
                modifier = Modifier.fillMaxWidth()
            )
        }
    }
}
