package com.paystack.android.core.api.services.mobilemoney

import com.paystack.android.core.api.ApiComponent
import com.paystack.android.core.api.ApiRequest
import com.paystack.android.core.api.asApiRequest
import com.paystack.android.core.api.models.MobileMoneyChargeRequest
import com.paystack.android.core.api.models.MobileMoneyChargeResponse
import com.paystack.android.core.api.services.transactions.TransactionApi

internal class MobileMoneyServiceImpl(
    private val transactionApi: TransactionApi,
) : MobileMoneyService {
    constructor(apiComponent: ApiComponent) : this(apiComponent.transactionApi)

    override fun charge(
        transactionId: String,
        provider: String,
        phone: String?,
    ): ApiRequest<MobileMoneyChargeResponse> {
        val chargeRequest = MobileMoneyChargeRequest(
            transactionId = transactionId,
            provider = provider,
            phone = phone,
            channelName = "MOBILE_MONEY_$transactionId"
        )
        return transactionApi.chargeMobileMoney(chargeRequest).asApiRequest()
    }
}
