package com.paystack.android.core.api.core

import okhttp3.Interceptor

internal class BasicAuthInterceptor constructor(private val authToken: String) : Interceptor {

    override fun intercept(chain: Interceptor.Chain): okhttp3.Response {
        var request = chain.request()
        request = request.newBuilder()
            .header("Authorization", "Bearer ${this.authToken}")
            .build()
        return chain.proceed(request)
    }
}
