/*
 * Decompiled with CFR 0.152.
 */
package com.paystack.android.core.api.services.cards;

import com.paystack.android.core.api.ApiComponent;
import com.paystack.android.core.api.ApiRequest;
import com.paystack.android.core.api.RetrofitApiRequestKt;
import com.paystack.android.core.api.core.encryption.EncryptionManager;
import com.paystack.android.core.api.models.AddressState;
import com.paystack.android.core.api.models.CardParams;
import com.paystack.android.core.api.models.ChargeRequest;
import com.paystack.android.core.api.models.ChargeResponse;
import com.paystack.android.core.api.models.RedirectAuthResponse;
import com.paystack.android.core.api.models.SubmitAddressRequest;
import com.paystack.android.core.api.models.SubmitBirthdayRequest;
import com.paystack.android.core.api.models.SubmitOtpRequest;
import com.paystack.android.core.api.models.SubmitPhoneRequest;
import com.paystack.android.core.api.models.SubmitPinRequest;
import com.paystack.android.core.api.services.cards.CardPaymentsService;
import com.paystack.android.core.api.services.cards.CardPaymentsServiceImpl;
import com.paystack.android.core.api.services.cards.RedirectAuthResultListener;
import com.paystack.android.core.api.services.transactions.TransactionApi;
import com.paystack.android.core.api.utilities.DateUtilsKt;
import com.paystack.android.core.events.EventManager;
import com.paystack.android.core.events.EventsComponent;
import com.paystack.android.core.events.Subscription;
import com.paystack.android.core.events.SubscriptionParams;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ6\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0014H\u0016J.\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0014H\u0016J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u0014H\u0016J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u0014H\u0016J&\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u0014H\u0016J&\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010%\u001a\u00020&2\u0006\u0010#\u001a\u00020\u0014H\u0016J\u001c\u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0(0\u00112\u0006\u0010*\u001a\u00020\u0014H\u0016J\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00142\u0006\u0010.\u001a\u00020/H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/paystack/android/core/api/services/cards/CardPaymentsServiceImpl;", "Lcom/paystack/android/core/api/services/cards/CardPaymentsService;", "apiComponent", "Lcom/paystack/android/core/api/ApiComponent;", "eventsComponent", "Lcom/paystack/android/core/events/EventsComponent;", "(Lcom/paystack/android/core/api/ApiComponent;Lcom/paystack/android/core/events/EventsComponent;)V", "transactionApi", "Lcom/paystack/android/core/api/services/transactions/TransactionApi;", "encryptionManager", "Lcom/paystack/android/core/api/core/encryption/EncryptionManager;", "eventManager", "Lcom/paystack/android/core/events/EventManager;", "(Lcom/paystack/android/core/api/services/transactions/TransactionApi;Lcom/paystack/android/core/api/core/encryption/EncryptionManager;Lcom/paystack/android/core/events/EventManager;)V", "json", "Lkotlinx/serialization/json/Json;", "authenticateWithAddress", "Lcom/paystack/android/core/api/ApiRequest;", "Lcom/paystack/android/core/api/models/ChargeResponse;", "accessCode", "", "address", "city", "state", "zipCode", "authenticateWithBirthday", "day", "month", "year", "authenticateWithOtp", "otp", "authenticateWithPhone", "phoneNumber", "authenticateWithPin", "pin", "encryptionKey", "charge", "cardParams", "Lcom/paystack/android/core/api/models/CardParams;", "getAddressStateList", "", "Lcom/paystack/android/core/api/models/AddressState;", "countryCode", "listenFor3dsResult", "", "transactionId", "callback", "Lcom/paystack/android/core/api/services/cards/RedirectAuthResultListener;", "paystack-core_release"})
@SourceDebugExtension(value={"SMAP\nCardPaymentsServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CardPaymentsServiceImpl.kt\ncom/paystack/android/core/api/services/cards/CardPaymentsServiceImpl\n+ 2 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 3 Serializers.kt\nkotlinx/serialization/SerializersKt__SerializersKt\n+ 4 Platform.common.kt\nkotlinx/serialization/internal/Platform_commonKt\n*L\n1#1,148:1\n113#2:149\n32#3:150\n80#4:151\n*S KotlinDebug\n*F\n+ 1 CardPaymentsServiceImpl.kt\ncom/paystack/android/core/api/services/cards/CardPaymentsServiceImpl\n*L\n45#1:149\n45#1:150\n45#1:151\n*E\n"})
public final class CardPaymentsServiceImpl
implements CardPaymentsService {
    @NotNull
    private final TransactionApi transactionApi;
    @NotNull
    private final EncryptionManager encryptionManager;
    @NotNull
    private final EventManager eventManager;
    @NotNull
    private final Json json;

    public CardPaymentsServiceImpl(@NotNull TransactionApi transactionApi, @NotNull EncryptionManager encryptionManager, @NotNull EventManager eventManager2) {
        Intrinsics.checkNotNullParameter((Object)transactionApi, (String)"transactionApi");
        Intrinsics.checkNotNullParameter((Object)encryptionManager, (String)"encryptionManager");
        Intrinsics.checkNotNullParameter((Object)eventManager2, (String)"eventManager");
        this.transactionApi = transactionApi;
        this.encryptionManager = encryptionManager;
        this.eventManager = eventManager2;
        this.json = JsonKt.Json$default(null, (Function1)json.1.INSTANCE, (int)1, null);
    }

    public CardPaymentsServiceImpl(@NotNull ApiComponent apiComponent, @NotNull EventsComponent eventsComponent) {
        Intrinsics.checkNotNullParameter((Object)apiComponent, (String)"apiComponent");
        Intrinsics.checkNotNullParameter((Object)eventsComponent, (String)"eventsComponent");
        this(apiComponent.getTransactionApi(), apiComponent.getEncryptionManager(), eventsComponent.getEventManager());
    }

    @Override
    @NotNull
    public ApiRequest<ChargeResponse> charge(@NotNull String accessCode, @NotNull CardParams cardParams, @NotNull String encryptionKey) {
        Intrinsics.checkNotNullParameter((Object)accessCode, (String)"accessCode");
        Intrinsics.checkNotNullParameter((Object)cardParams, (String)"cardParams");
        Intrinsics.checkNotNullParameter((Object)encryptionKey, (String)"encryptionKey");
        StringFormat $this$encodeToString$iv = (StringFormat)Json.Default;
        boolean $i$f$encodeToString = false;
        SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(CardParams.class));
        boolean $i$f$cast = false;
        Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
        String cardData = this.encryptionManager.encrypt($this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, (Object)cardParams), encryptionKey);
        ChargeRequest chargeRequest = new ChargeRequest(accessCode, cardData);
        return RetrofitApiRequestKt.asApiRequest(this.transactionApi.charge(chargeRequest));
    }

    @Override
    @NotNull
    public ApiRequest<ChargeResponse> authenticateWithPin(@NotNull String accessCode, @NotNull String pin, @NotNull String encryptionKey) {
        Intrinsics.checkNotNullParameter((Object)accessCode, (String)"accessCode");
        Intrinsics.checkNotNullParameter((Object)pin, (String)"pin");
        Intrinsics.checkNotNullParameter((Object)encryptionKey, (String)"encryptionKey");
        SubmitPinRequest request = new SubmitPinRequest(accessCode, this.encryptionManager.encrypt(pin, encryptionKey));
        return RetrofitApiRequestKt.asApiRequest(this.transactionApi.submitPin(request));
    }

    @Override
    @NotNull
    public ApiRequest<ChargeResponse> authenticateWithAddress(@NotNull String accessCode, @NotNull String address, @NotNull String city, @NotNull String state, @NotNull String zipCode) {
        Intrinsics.checkNotNullParameter((Object)accessCode, (String)"accessCode");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)city, (String)"city");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)zipCode, (String)"zipCode");
        SubmitAddressRequest request = new SubmitAddressRequest(accessCode, address, city, state, zipCode);
        return RetrofitApiRequestKt.asApiRequest(this.transactionApi.submitAddress(request));
    }

    @Override
    @NotNull
    public ApiRequest<List<AddressState>> getAddressStateList(@NotNull String countryCode) {
        Intrinsics.checkNotNullParameter((Object)countryCode, (String)"countryCode");
        return RetrofitApiRequestKt.asApiRequest(this.transactionApi.getAvsStates(countryCode));
    }

    @Override
    @NotNull
    public ApiRequest<ChargeResponse> authenticateWithOtp(@NotNull String accessCode, @NotNull String otp) {
        Intrinsics.checkNotNullParameter((Object)accessCode, (String)"accessCode");
        Intrinsics.checkNotNullParameter((Object)otp, (String)"otp");
        SubmitOtpRequest request = new SubmitOtpRequest(accessCode, otp);
        return RetrofitApiRequestKt.asApiRequest(this.transactionApi.submitOtp(request));
    }

    @Override
    @NotNull
    public ApiRequest<ChargeResponse> authenticateWithPhone(@NotNull String accessCode, @NotNull String phoneNumber) {
        Intrinsics.checkNotNullParameter((Object)accessCode, (String)"accessCode");
        Intrinsics.checkNotNullParameter((Object)phoneNumber, (String)"phoneNumber");
        SubmitPhoneRequest request = new SubmitPhoneRequest(phoneNumber, accessCode);
        return RetrofitApiRequestKt.asApiRequest(this.transactionApi.submitPhone(request));
    }

    @Override
    @NotNull
    public ApiRequest<ChargeResponse> authenticateWithBirthday(@NotNull String accessCode, @NotNull String day, @NotNull String month, @NotNull String year) {
        Intrinsics.checkNotNullParameter((Object)accessCode, (String)"accessCode");
        Intrinsics.checkNotNullParameter((Object)day, (String)"day");
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        Intrinsics.checkNotNullParameter((Object)year, (String)"year");
        boolean isValidDate = DateUtilsKt.isDateValid(year, month, day);
        if (isValidDate) {
            SubmitBirthdayRequest request = new SubmitBirthdayRequest(accessCode, year + "-" + month + "-" + day);
            return RetrofitApiRequestKt.asApiRequest(this.transactionApi.submitBirthday(request));
        }
        throw new IllegalArgumentException("Invalid date");
    }

    @Override
    public void listenFor3dsResult(@NotNull String transactionId, @NotNull RedirectAuthResultListener callback) {
        Intrinsics.checkNotNullParameter((Object)transactionId, (String)"transactionId");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        String channelName = "3DS_" + transactionId;
        Ref.ObjectRef subscription = new Ref.ObjectRef();
        subscription.element = this.eventManager.subscribe(new SubscriptionParams(channelName, "response"), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this, callback, (Ref.ObjectRef<Subscription>)subscription){
            final /* synthetic */ CardPaymentsServiceImpl this$0;
            final /* synthetic */ RedirectAuthResultListener $callback;
            final /* synthetic */ Ref.ObjectRef<Subscription> $subscription;
            {
                this.this$0 = $receiver;
                this.$callback = $callback;
                this.$subscription = $subscription;
                super(1);
            }

            public final void invoke(@NotNull String result) {
                block5: {
                    Throwable throwable;
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                    Object object2 = this.this$0;
                    try {
                        CardPaymentsServiceImpl $this$invoke_u24lambda_u240 = object2;
                        boolean bl = false;
                        StringFormat $this$decodeFromString$iv = (StringFormat)CardPaymentsServiceImpl.access$getJson$p($this$invoke_u24lambda_u240);
                        boolean $i$f$decodeFromString = false;
                        SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
                        boolean $i$f$serializer = false;
                        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(RedirectAuthResponse.class));
                        boolean $i$f$cast = false;
                        Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
                        object = Result.constructor-impl((Object)((RedirectAuthResponse)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, result)));
                    }
                    catch (Throwable throwable2) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                    }
                    object2 = object;
                    object = this.$callback;
                    Ref.ObjectRef<Subscription> objectRef = this.$subscription;
                    if (Result.isSuccess-impl((Object)object2)) {
                        RedirectAuthResponse transaction = (RedirectAuthResponse)object2;
                        boolean bl = false;
                        object.onResult(transaction);
                        Subscription subscription = (Subscription)objectRef.element;
                        if (subscription != null) {
                            subscription.cancel();
                        }
                    }
                    object = this.$callback;
                    objectRef = this.$subscription;
                    Throwable throwable3 = Result.exceptionOrNull-impl((Object)object2);
                    if (throwable3 == null) break block5;
                    Throwable it = throwable = throwable3;
                    boolean bl = false;
                    object.onError(it);
                    Subscription subscription = (Subscription)objectRef.element;
                    if (subscription != null) {
                        subscription.cancel();
                    }
                }
            }
        }));
    }

    public static final /* synthetic */ Json access$getJson$p(CardPaymentsServiceImpl $this) {
        return $this.json;
    }
}

