package com.paystack.android.core.api.core

import com.jakewharton.retrofit2.converter.kotlinx.serialization.asConverterFactory
import com.paystack.android.core.api.core.exceptions.AuthenticationException
import kotlinx.serialization.ExperimentalSerializationApi
import kotlinx.serialization.json.Json
import okhttp3.MediaType.Companion.toMediaType
import okhttp3.OkHttpClient
import retrofit2.Retrofit
import retrofit2.create

@OptIn(ExperimentalSerializationApi::class)
internal class Service {

    data class Builder(private var authToken: String? = null) {

        private val contentType = "application/json"
            .toMediaType()
        private val json = Json {
            prettyPrint = true
            ignoreUnknownKeys = true
            isLenient = true
        }

        fun setAuthToken(authToken: String) = apply { this.authToken = authToken }

        @Throws(Exception::class)
        fun build(): Retrofit {
            this.authToken?.let {
                val client = OkHttpClient.Builder()
                    .addInterceptor(BasicAuthInterceptor(it))
                    .addInterceptor { chain ->
                        val request = chain.request().newBuilder()
                            .addDeviceInfoHeaders()
                            .addSdkVersionHeader()
                            .addDeviceIdentifierHeader()
                            .build()
                        return@addInterceptor chain.proceed(request)
                    }
                    .build()
                return Retrofit.Builder()
                    .baseUrl("https://api.paystack.co")
                    .client(client)
                    .addConverterFactory(json.asConverterFactory(contentType))
                    .build()
            }
            throw AuthenticationException("Authentication Token is not set")
        }

        inline fun <reified T> createApiService(): T {
            return build().create()
        }
    }
}
