/*
 * Decompiled with CFR 0.152.
 */
package com.paystack.android.core.events.pusher;

import com.paystack.android.core.events.EventManager;
import com.paystack.android.core.events.Subscription;
import com.paystack.android.core.events.SubscriptionParams;
import com.paystack.android.core.logging.Logger;
import com.pusher.client.Pusher;
import com.pusher.client.channel.ChannelEventListener;
import com.pusher.client.channel.PusherEvent;
import com.pusher.client.connection.ConnectionEventListener;
import com.pusher.client.connection.ConnectionState;
import com.pusher.client.connection.ConnectionStateChange;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0002J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00060\fH\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/paystack/android/core/events/pusher/PusherEventManager;", "Lcom/paystack/android/core/events/EventManager;", "pusher", "Lcom/pusher/client/Pusher;", "(Lcom/pusher/client/Pusher;)V", "connect", "", "subscribe", "Lcom/paystack/android/core/events/Subscription;", "params", "Lcom/paystack/android/core/events/SubscriptionParams;", "onEvent", "Lkotlin/Function1;", "", "unsubscribe", "channelName", "paystack-core_release"})
public final class PusherEventManager
implements EventManager {
    @NotNull
    private final Pusher pusher;

    public PusherEventManager(@NotNull Pusher pusher) {
        Intrinsics.checkNotNullParameter((Object)pusher, (String)"pusher");
        this.pusher = pusher;
        this.connect();
    }

    private final void connect() {
        ConnectionState[] connectionStateArray = new ConnectionState[]{ConnectionState.ALL};
        this.pusher.connect(new ConnectionEventListener(){

            public void onConnectionStateChange(@NotNull ConnectionStateChange change) {
                Intrinsics.checkNotNullParameter((Object)change, (String)"change");
                Logger.INSTANCE.debug("State changed from " + change.getPreviousState() + " to " + change.getCurrentState());
            }

            public void onError(@NotNull String message, @Nullable String code, @Nullable Exception e) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Logger.INSTANCE.error(e, "Pusher Connection error! Code: (" + code + ")");
            }
        }, connectionStateArray);
    }

    @Override
    @NotNull
    public Subscription subscribe(@NotNull SubscriptionParams params, @NotNull Function1<? super String, Unit> onEvent) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter(onEvent, (String)"onEvent");
        String channelName = params.component1();
        String eventName = params.component2();
        ChannelEventListener channelEventListener2 = new ChannelEventListener(onEvent){
            final /* synthetic */ Function1<String, Unit> $onEvent;
            {
                this.$onEvent = $onEvent;
            }

            public void onEvent(@NotNull PusherEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                String string = event.getData();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.data");
                this.$onEvent.invoke((Object)string);
            }

            public void onSubscriptionSucceeded(@NotNull String channelName) {
                Intrinsics.checkNotNullParameter((Object)channelName, (String)"channelName");
                Logger.INSTANCE.debug("Subscribed to " + channelName);
            }
        };
        String[] stringArray = new String[]{eventName};
        this.pusher.subscribe(channelName, channelEventListener2, stringArray);
        return () -> PusherEventManager.subscribe$lambda$0(this, channelName);
    }

    @Override
    public void unsubscribe(@NotNull String channelName) {
        Intrinsics.checkNotNullParameter((Object)channelName, (String)"channelName");
        this.pusher.unsubscribe(channelName);
    }

    private static final void subscribe$lambda$0(PusherEventManager this$0, String $channelName) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$channelName, (String)"$channelName");
        this$0.unsubscribe($channelName);
    }
}

