/*
 * Decompiled with CFR 0.152.
 */
package com.paystack.android.core.logging;

import android.os.Build;
import android.util.Log;
import androidx.annotation.RestrictTo;
import com.paystack.android.core.Paystack;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\r\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u0010\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u001a\u0010\u0010\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0012\u001a\u0004\u0018\u00010\rJ\u001a\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u0015\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u001a\u0010\u0015\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0012\u001a\u0004\u0018\u00010\rJ\b\u0010\u0018\u001a\u00020\rH\u0002J\u0010\u0010\u0019\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u0019\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u001a\u0010\u0019\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0012\u001a\u0004\u0018\u00010\rJ\"\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001d\u001a\u00020\rH\u0002J$\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0012\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010\u001f\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u001f\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u001a\u0010\u001f\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0012\u001a\u0004\u0018\u00010\rJ\u0010\u0010 \u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\rJ\u0010\u0010 \u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u001a\u0010 \u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0012\u001a\u0004\u0018\u00010\rR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\u00a8\u0006!"}, d2={"Lcom/paystack/android/core/logging/Logger;", "", "()V", "ANONYMOUS_CLASS", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "MAX_LOG_LENGTH", "", "MAX_TAG_LENGTH", "isEnabled", "", "()Z", "createStackElementTag", "", "element", "Ljava/lang/StackTraceElement;", "debug", "", "message", "t", "", "error", "errorMessage", "throwable", "getTag", "info", "log", "priority", "tag", "msg", "prepareLog", "verbose", "warn", "paystack-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Logger.kt\ncom/paystack/android/core/logging/Logger\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,211:1\n1109#2,2:212\n1#3:214\n*S KotlinDebug\n*F\n+ 1 Logger.kt\ncom/paystack/android/core/logging/Logger\n*L\n186#1:212,2\n*E\n"})
public final class Logger {
    @NotNull
    public static final Logger INSTANCE = new Logger();
    private static final int MAX_LOG_LENGTH = 4000;
    private static final int MAX_TAG_LENGTH = 23;
    private static final Pattern ANONYMOUS_CLASS = Pattern.compile("(\\$\\d+)+$");

    private Logger() {
    }

    private final boolean isEnabled() {
        return Paystack.Builder.Companion.isInitialized$paystack_core_release() ? Paystack.Builder.Companion.getInstance().getConfig$paystack_core_release().getEnableLogging() : false;
    }

    public final void verbose(@Nullable String message) {
        this.prepareLog(2, null, message);
    }

    public final void verbose(@Nullable Throwable t, @Nullable String message) {
        this.prepareLog(2, t, message);
    }

    public final void verbose(@Nullable Throwable t) {
        this.prepareLog(2, t, null);
    }

    public final void debug(@Nullable String message) {
        this.prepareLog(3, null, message);
    }

    public final void debug(@Nullable Throwable t, @Nullable String message) {
        this.prepareLog(3, t, message);
    }

    public final void debug(@Nullable Throwable t) {
        this.prepareLog(3, t, null);
    }

    public final void info(@Nullable String message) {
        this.prepareLog(4, null, message);
    }

    public final void info(@Nullable Throwable t, @Nullable String message) {
        this.prepareLog(4, t, message);
    }

    public final void info(@Nullable Throwable t) {
        this.prepareLog(4, t, null);
    }

    public final void warn(@Nullable String message) {
        this.prepareLog(5, null, message);
    }

    public final void warn(@Nullable Throwable t, @Nullable String message) {
        this.prepareLog(5, t, message);
    }

    public final void warn(@Nullable Throwable t) {
        this.prepareLog(5, t, null);
    }

    public final void error(@Nullable String message) {
        this.prepareLog(6, null, message);
    }

    @Deprecated(message="Use error(t: Throwable?, message: String?) instead", replaceWith=@ReplaceWith(expression="Logger.error(throwable, errorMessage)", imports={}))
    public final void error(@NotNull String errorMessage, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        this.error(throwable, errorMessage);
    }

    public final void error(@Nullable Throwable t, @Nullable String message) {
        this.prepareLog(6, t, message);
    }

    public final void error(@Nullable Throwable t) {
        this.prepareLog(6, t, null);
    }

    private final void prepareLog(int priority, Throwable t, String message) {
        if (!this.isEnabled()) {
            return;
        }
        String tag = this.getTag();
        Object msg = message;
        CharSequence charSequence = (CharSequence)msg;
        if (charSequence == null || charSequence.length() == 0) {
            if (t == null) {
                return;
            }
            msg = Log.getStackTraceString((Throwable)t);
        } else if (t != null) {
            msg = (String)msg + "\n" + Log.getStackTraceString((Throwable)t);
        }
        this.log(priority, tag, (String)msg);
    }

    private final void log(int priority, String tag, String msg) {
        if (msg.length() < 4000) {
            Log.println((int)priority, (String)tag, (String)msg);
            return;
        }
        int length = msg.length();
        for (int i = 0; i < length; ++i) {
            int end;
            int newline = StringsKt.indexOf$default((CharSequence)msg, (char)'\n', (int)i, (boolean)false, (int)4, null);
            newline = newline != -1 ? newline : length;
            do {
                String part;
                end = Math.min(newline, i + 4000);
                Intrinsics.checkNotNullExpressionValue((Object)msg.substring(i, end), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                Log.println((int)priority, (String)tag, (String)part);
            } while ((i = end) < newline);
        }
    }

    private final String getTag() {
        Object element$iv2;
        block2: {
            StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"Throwable().stackTrace");
            Object[] $this$first$iv = stackTraceElementArray;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                StackTraceElement it = (StackTraceElement)element$iv2;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it.getClassName(), (Object)Logger.class.getName()))) {
                    continue;
                }
                break block2;
            }
            throw new NoSuchElementException("Array contains no element matching the predicate.");
        }
        StackTraceElement p0 = (StackTraceElement)element$iv2;
        boolean bl = false;
        return this.createStackElementTag(p0);
    }

    private final String createStackElementTag(StackTraceElement element) {
        String string;
        String string2 = element.getClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"element.className");
        String tag = StringsKt.substringAfterLast$default((String)string2, (char)'.', null, (int)2, null);
        Matcher m = ANONYMOUS_CLASS.matcher(tag);
        if (m.find()) {
            String string3 = m.replaceAll("");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"m.replaceAll(\"\")");
            tag = string3;
        }
        if (tag.length() <= 23 || Build.VERSION.SDK_INT >= 26) {
            string = tag;
        } else {
            String string4 = tag.substring(0, 23);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        }
        return string;
    }
}

