package com.paystack.android.core.api.models

import androidx.annotation.RestrictTo

class PaystackError @RestrictTo(RestrictTo.Scope.LIBRARY_GROUP) constructor(
    override val message: String,
    override val cause: Throwable? = null
) : Exception(message) {

    @RestrictTo(RestrictTo.Scope.LIBRARY_GROUP)
    constructor(exception: Throwable) : this(
        message = exception.message.orEmpty(),
        cause = exception
    )
}

@RestrictTo(RestrictTo.Scope.LIBRARY_GROUP)
fun Throwable.asPaystackError(): PaystackError {
    return PaystackError(this)
}
