package com.paystack.android_sdk.core.api.models

import com.paystack.android_sdk.core.logging.Logger
import kotlinx.serialization.KSerializer
import kotlinx.serialization.Serializable
import kotlinx.serialization.descriptors.SerialDescriptor
import kotlinx.serialization.descriptors.serialDescriptor
import kotlinx.serialization.encoding.Decoder
import kotlinx.serialization.encoding.Encoder

/**
 * Supported Payment channels
 */
@Serializable(with = PaymentChannel.PaymentChannelSerializer::class)
enum class PaymentChannel {
    CARD,
    UNSUPPORTED;

    object PaymentChannelSerializer : KSerializer<PaymentChannel> {
        override val descriptor: SerialDescriptor
            get() = serialDescriptor<String>()

        override fun deserialize(decoder: Decoder): PaymentChannel {
            val value = decoder.decodeString().uppercase()
            return try {
                enumValueOf(value)
            } catch (e: IllegalArgumentException) {
                Logger.error(e.message ?: "Unknown enum value: $value", e)
                UNSUPPORTED
            }
        }

        override fun serialize(encoder: Encoder, value: PaymentChannel) {
            encoder.encodeString(value.name.lowercase())
        }
    }
}
