package com.paystack.android_sdk.core.api

import com.paystack.android_sdk.core.PaystackConfig
import com.paystack.android_sdk.core.api.core.Service
import com.paystack.android_sdk.core.api.core.encryption.EncryptionManager
import com.paystack.android_sdk.core.api.core.encryption.RsaEncryptionManager
import com.paystack.android_sdk.core.api.transactions.TransactionApi

internal fun apiComponent(config: PaystackConfig) = ApiModule(config)

internal interface ApiComponent {
    val transactionApi: TransactionApi
    val encryptionManager: EncryptionManager
}

internal class ApiModule constructor(private val serviceBuilder: Service.Builder) : ApiComponent {
    constructor(config: PaystackConfig) : this(Service.Builder(config.publicKey))

    override val transactionApi: TransactionApi
        get() = serviceBuilder.createApiService()

    override val encryptionManager: EncryptionManager
        get() = RsaEncryptionManager()
}
