/*
 * Decompiled with CFR 0.152.
 */
package com.paystack.android_sdk.core.logging;

import android.util.Log;
import androidx.annotation.RestrictTo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004J\u0018\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004J\u000e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/paystack/android_sdk/core/logging/Logger;", "", "()V", "LOG_TAG", "", "isEnabled", "", "()Z", "setEnabled", "(Z)V", "debug", "", "message", "error", "errorMessage", "throwable", "", "info", "verbose", "paystack-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class Logger {
    @NotNull
    public static final Logger INSTANCE = new Logger();
    private static boolean isEnabled;
    @NotNull
    private static final String LOG_TAG = "paystack.androidsdk";

    private Logger() {
    }

    public final boolean isEnabled() {
        return isEnabled;
    }

    public final void setEnabled(boolean bl) {
        isEnabled = bl;
    }

    public final void verbose(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (isEnabled) {
            Log.v((String)LOG_TAG, (String)message);
        }
    }

    public final void info(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (isEnabled) {
            Log.i((String)LOG_TAG, (String)message);
        }
    }

    public final void debug(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (isEnabled) {
            Log.d((String)LOG_TAG, (String)message);
        }
    }

    public final void error(@NotNull String errorMessage, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        if (isEnabled) {
            Log.e((String)LOG_TAG, (String)errorMessage, (Throwable)throwable);
        }
    }
}

