/*
 * Decompiled with CFR 0.152.
 */
package com.paystack.android_sdk.core.api.core.encryption;

import android.util.Base64;
import com.paystack.android_sdk.core.api.core.encryption.EncryptionManager;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u0003\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/paystack/android_sdk/core/api/core/encryption/RsaEncryptionManager;", "Lcom/paystack/android_sdk/core/api/core/encryption/EncryptionManager;", "()V", "encrypt", "", "text", "", "publicKey", "Ljava/security/PublicKey;", "readPublicKey", "Companion", "paystack-core_release"})
public final class RsaEncryptionManager
implements EncryptionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String ALGORITHM = "RSA";
    @NotNull
    private static final String CIPHER = "RSA/ECB/OAEPPadding";

    @Override
    @NotNull
    public String encrypt(@NotNull String text, @NotNull String publicKey) throws GeneralSecurityException {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        String string = Base64.encodeToString((byte[])this.encrypt(text, this.readPublicKey(publicKey)), (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(\n        \u2026 Base64.NO_WRAP\n        )");
        return string;
    }

    @Override
    @NotNull
    public byte[] encrypt(@NotNull String text, @NotNull PublicKey publicKey) throws GeneralSecurityException {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Cipher cipher = Cipher.getInstance(CIPHER);
        cipher.init(1, publicKey);
        String string = text;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = cipher.doFinal(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"cipher.doFinal(text.toByteArray())");
        return byArray2;
    }

    private final PublicKey readPublicKey(String publicKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
        byte[] keyBytes = Base64.decode((String)publicKey, (int)2);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        PublicKey publicKey2 = keyFactory.generatePublic(keySpec);
        Intrinsics.checkNotNullExpressionValue((Object)publicKey2, (String)"keyFactory.generatePublic(keySpec)");
        return publicKey2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/paystack/android_sdk/core/api/core/encryption/RsaEncryptionManager$Companion;", "", "()V", "ALGORITHM", "", "CIPHER", "paystack-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

