package com.paystack.android_sdk.core.api.core.encryption

import java.security.GeneralSecurityException
import java.security.PublicKey

interface EncryptionManager {
    /**
     * Encrypts a string using the public key.
     *
     * @param text The string to encrypt.
     * @param publicKey The public encryption key.
     * @return The encrypted string, encoded as Base64.
     * @throws GeneralSecurityException if there's a problem reading the public key,
     * If the requested algorithm is not supported by the underlying cryptographic library
     * or there's a failure reading the input data
     */
    @Throws(GeneralSecurityException::class)
    fun encrypt(text: String, publicKey: String): String

    /**
     * Encrypts a string using the public key.
     *
     * @param text The string to encrypt.
     * @param publicKey The public key used for the encryption.
     * @return The encrypted string, encoded as Base64.
     * @throws GeneralSecurityException If the requested algorithm is not supported by the
     * underlying cryptographic library or there's a failure reading the input data
     */
    @Throws(GeneralSecurityException::class)
    fun encrypt(text: String, publicKey: PublicKey): ByteArray
}
