package com.paystack.android.core.api.core

import android.os.Build
import androidx.annotation.OpenForTesting
import com.paystack.android.core.BuildConfig
import com.paystack.android.core.api.utilities.capitalize
import okhttp3.Request

@OpenForTesting
internal fun Request.Builder.addDeviceInfoHeaders(): Request.Builder {
    addHeader("x-platform", "AndroidSDK")
    addHeader("x-platform-version", "${Build.VERSION.SDK_INT}")
    addHeader("x-device", getDeviceName())
    return this
}

@OpenForTesting
internal fun Request.Builder.addDeviceIdentifierHeader(): Request.Builder {
    addHeader(
        "x-device-identifier",
        "sdk_android_"
    ) //TODO: Add Android ID Settings.Secure.getString(context.contentResolver,Settings.Secure.ANDROID_ID))
    return this
}

@OpenForTesting
internal fun Request.Builder.addSdkVersionHeader(): Request.Builder {
    addHeader("x-sdk-version", BuildConfig.PSTK_SDK_VERSION)
    return this
}

private fun getDeviceName(): String {
    val manufacturer = Build.MANUFACTURER
    val model = Build.MODEL
    return if (model.startsWith(manufacturer)) {
        model.capitalize()
    } else {
        "${manufacturer.capitalize()} $model"
    }
}
