/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.CallbackConfiguration;
import com.paypal.sdk.models.ShippingPreference;

public class VenmoWalletExperienceContext {
    private String brandName;
    private ShippingPreference shippingPreference;
    private CallbackConfiguration orderUpdateCallbackConfig;

    public VenmoWalletExperienceContext() {
        this.shippingPreference = ShippingPreference.GET_FROM_FILE;
    }

    public VenmoWalletExperienceContext(String brandName, ShippingPreference shippingPreference, CallbackConfiguration orderUpdateCallbackConfig) {
        this.brandName = brandName;
        this.shippingPreference = shippingPreference;
        this.orderUpdateCallbackConfig = orderUpdateCallbackConfig;
    }

    @JsonGetter(value="brand_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getBrandName() {
        return this.brandName;
    }

    @JsonSetter(value="brand_name")
    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    @JsonGetter(value="shipping_preference")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ShippingPreference getShippingPreference() {
        return this.shippingPreference;
    }

    @JsonSetter(value="shipping_preference")
    public void setShippingPreference(ShippingPreference shippingPreference) {
        this.shippingPreference = shippingPreference;
    }

    @JsonGetter(value="order_update_callback_config")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CallbackConfiguration getOrderUpdateCallbackConfig() {
        return this.orderUpdateCallbackConfig;
    }

    @JsonSetter(value="order_update_callback_config")
    public void setOrderUpdateCallbackConfig(CallbackConfiguration orderUpdateCallbackConfig) {
        this.orderUpdateCallbackConfig = orderUpdateCallbackConfig;
    }

    public String toString() {
        return "VenmoWalletExperienceContext [brandName=" + this.brandName + ", shippingPreference=" + (Object)((Object)this.shippingPreference) + ", orderUpdateCallbackConfig=" + this.orderUpdateCallbackConfig + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().brandName(this.getBrandName()).shippingPreference(this.getShippingPreference()).orderUpdateCallbackConfig(this.getOrderUpdateCallbackConfig());
        return builder;
    }

    public static class Builder {
        private String brandName;
        private ShippingPreference shippingPreference = ShippingPreference.GET_FROM_FILE;
        private CallbackConfiguration orderUpdateCallbackConfig;

        public Builder brandName(String brandName) {
            this.brandName = brandName;
            return this;
        }

        public Builder shippingPreference(ShippingPreference shippingPreference) {
            this.shippingPreference = shippingPreference;
            return this;
        }

        public Builder orderUpdateCallbackConfig(CallbackConfiguration orderUpdateCallbackConfig) {
            this.orderUpdateCallbackConfig = orderUpdateCallbackConfig;
            return this;
        }

        public VenmoWalletExperienceContext build() {
            return new VenmoWalletExperienceContext(this.brandName, this.shippingPreference, this.orderUpdateCallbackConfig);
        }
    }
}

