/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.BillingCycle;
import com.paypal.sdk.models.Money;
import java.util.List;

public class OrderBillingPlan {
    private List<BillingCycle> billingCycles;
    private Money setupFee;
    private String name;

    public OrderBillingPlan() {
    }

    public OrderBillingPlan(List<BillingCycle> billingCycles, Money setupFee, String name) {
        this.billingCycles = billingCycles;
        this.setupFee = setupFee;
        this.name = name;
    }

    @JsonGetter(value="billing_cycles")
    public List<BillingCycle> getBillingCycles() {
        return this.billingCycles;
    }

    @JsonSetter(value="billing_cycles")
    public void setBillingCycles(List<BillingCycle> billingCycles) {
        this.billingCycles = billingCycles;
    }

    @JsonGetter(value="setup_fee")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getSetupFee() {
        return this.setupFee;
    }

    @JsonSetter(value="setup_fee")
    public void setSetupFee(Money setupFee) {
        this.setupFee = setupFee;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    @JsonSetter(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "OrderBillingPlan [billingCycles=" + this.billingCycles + ", setupFee=" + this.setupFee + ", name=" + this.name + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.billingCycles).setupFee(this.getSetupFee()).name(this.getName());
        return builder;
    }

    public static class Builder {
        private List<BillingCycle> billingCycles;
        private Money setupFee;
        private String name;

        public Builder() {
        }

        public Builder(List<BillingCycle> billingCycles) {
            this.billingCycles = billingCycles;
        }

        public Builder billingCycles(List<BillingCycle> billingCycles) {
            this.billingCycles = billingCycles;
            return this;
        }

        public Builder setupFee(Money setupFee) {
            this.setupFee = setupFee;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public OrderBillingPlan build() {
            return new OrderBillingPlan(this.billingCycles, this.setupFee, this.name);
        }
    }
}

