/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.Address;
import com.paypal.sdk.models.LineItem;
import com.paypal.sdk.models.Money;
import java.util.List;

public class Level3CardProcessingData {
    private Money shippingAmount;
    private Money dutyAmount;
    private Money discountAmount;
    private Address shippingAddress;
    private String shipsFromPostalCode;
    private List<LineItem> lineItems;

    public Level3CardProcessingData() {
    }

    public Level3CardProcessingData(Money shippingAmount, Money dutyAmount, Money discountAmount, Address shippingAddress, String shipsFromPostalCode, List<LineItem> lineItems) {
        this.shippingAmount = shippingAmount;
        this.dutyAmount = dutyAmount;
        this.discountAmount = discountAmount;
        this.shippingAddress = shippingAddress;
        this.shipsFromPostalCode = shipsFromPostalCode;
        this.lineItems = lineItems;
    }

    @JsonGetter(value="shipping_amount")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getShippingAmount() {
        return this.shippingAmount;
    }

    @JsonSetter(value="shipping_amount")
    public void setShippingAmount(Money shippingAmount) {
        this.shippingAmount = shippingAmount;
    }

    @JsonGetter(value="duty_amount")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getDutyAmount() {
        return this.dutyAmount;
    }

    @JsonSetter(value="duty_amount")
    public void setDutyAmount(Money dutyAmount) {
        this.dutyAmount = dutyAmount;
    }

    @JsonGetter(value="discount_amount")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getDiscountAmount() {
        return this.discountAmount;
    }

    @JsonSetter(value="discount_amount")
    public void setDiscountAmount(Money discountAmount) {
        this.discountAmount = discountAmount;
    }

    @JsonGetter(value="shipping_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Address getShippingAddress() {
        return this.shippingAddress;
    }

    @JsonSetter(value="shipping_address")
    public void setShippingAddress(Address shippingAddress) {
        this.shippingAddress = shippingAddress;
    }

    @JsonGetter(value="ships_from_postal_code")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getShipsFromPostalCode() {
        return this.shipsFromPostalCode;
    }

    @JsonSetter(value="ships_from_postal_code")
    public void setShipsFromPostalCode(String shipsFromPostalCode) {
        this.shipsFromPostalCode = shipsFromPostalCode;
    }

    @JsonGetter(value="line_items")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    @JsonSetter(value="line_items")
    public void setLineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
    }

    public String toString() {
        return "Level3CardProcessingData [shippingAmount=" + this.shippingAmount + ", dutyAmount=" + this.dutyAmount + ", discountAmount=" + this.discountAmount + ", shippingAddress=" + this.shippingAddress + ", shipsFromPostalCode=" + this.shipsFromPostalCode + ", lineItems=" + this.lineItems + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().shippingAmount(this.getShippingAmount()).dutyAmount(this.getDutyAmount()).discountAmount(this.getDiscountAmount()).shippingAddress(this.getShippingAddress()).shipsFromPostalCode(this.getShipsFromPostalCode()).lineItems(this.getLineItems());
        return builder;
    }

    public static class Builder {
        private Money shippingAmount;
        private Money dutyAmount;
        private Money discountAmount;
        private Address shippingAddress;
        private String shipsFromPostalCode;
        private List<LineItem> lineItems;

        public Builder shippingAmount(Money shippingAmount) {
            this.shippingAmount = shippingAmount;
            return this;
        }

        public Builder dutyAmount(Money dutyAmount) {
            this.dutyAmount = dutyAmount;
            return this;
        }

        public Builder discountAmount(Money discountAmount) {
            this.discountAmount = discountAmount;
            return this;
        }

        public Builder shippingAddress(Address shippingAddress) {
            this.shippingAddress = shippingAddress;
            return this;
        }

        public Builder shipsFromPostalCode(String shipsFromPostalCode) {
            this.shipsFromPostalCode = shipsFromPostalCode;
            return this;
        }

        public Builder lineItems(List<LineItem> lineItems) {
            this.lineItems = lineItems;
            return this;
        }

        public Level3CardProcessingData build() {
            return new Level3CardProcessingData(this.shippingAmount, this.dutyAmount, this.discountAmount, this.shippingAddress, this.shipsFromPostalCode, this.lineItems);
        }
    }
}

