/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.AmountBreakdown;

public class AmountWithBreakdown {
    private String currencyCode;
    private String value;
    private AmountBreakdown breakdown;

    public AmountWithBreakdown() {
    }

    public AmountWithBreakdown(String currencyCode, String value, AmountBreakdown breakdown) {
        this.currencyCode = currencyCode;
        this.value = value;
        this.breakdown = breakdown;
    }

    @JsonGetter(value="currency_code")
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    @JsonSetter(value="currency_code")
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    @JsonGetter(value="value")
    public String getValue() {
        return this.value;
    }

    @JsonSetter(value="value")
    public void setValue(String value) {
        this.value = value;
    }

    @JsonGetter(value="breakdown")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public AmountBreakdown getBreakdown() {
        return this.breakdown;
    }

    @JsonSetter(value="breakdown")
    public void setBreakdown(AmountBreakdown breakdown) {
        this.breakdown = breakdown;
    }

    public String toString() {
        return "AmountWithBreakdown [currencyCode=" + this.currencyCode + ", value=" + this.value + ", breakdown=" + this.breakdown + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.currencyCode, this.value).breakdown(this.getBreakdown());
        return builder;
    }

    public static class Builder {
        private String currencyCode;
        private String value;
        private AmountBreakdown breakdown;

        public Builder() {
        }

        public Builder(String currencyCode, String value) {
            this.currencyCode = currencyCode;
            this.value = value;
        }

        public Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Builder breakdown(AmountBreakdown breakdown) {
            this.breakdown = breakdown;
            return this;
        }

        public AmountWithBreakdown build() {
            return new AmountWithBreakdown(this.currencyCode, this.value, this.breakdown);
        }
    }
}

