/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.controllers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.paypal.sdk.ApiHelper;
import com.paypal.sdk.Server;
import com.paypal.sdk.controllers.BaseController;
import com.paypal.sdk.exceptions.ApiException;
import com.paypal.sdk.exceptions.ErrorException;
import com.paypal.sdk.http.request.HttpMethod;
import com.paypal.sdk.http.response.ApiResponse;
import com.paypal.sdk.models.AuthorizeOrderInput;
import com.paypal.sdk.models.CaptureOrderInput;
import com.paypal.sdk.models.ConfirmOrderInput;
import com.paypal.sdk.models.CreateOrderInput;
import com.paypal.sdk.models.CreateOrderTrackingInput;
import com.paypal.sdk.models.GetOrderInput;
import com.paypal.sdk.models.Order;
import com.paypal.sdk.models.OrderAuthorizeResponse;
import com.paypal.sdk.models.PatchOrderInput;
import com.paypal.sdk.models.UpdateOrderTrackingInput;
import io.apimatic.core.ApiCall;
import io.apimatic.core.ErrorCase;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.http.Method;
import io.apimatic.coreinterfaces.http.request.ResponseClassType;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class OrdersController
extends BaseController {
    public OrdersController(GlobalConfiguration globalConfig) {
        super(globalConfig);
    }

    public ApiResponse<Void> patchOrder(PatchOrderInput input) throws ApiException, IOException {
        return (ApiResponse)this.preparePatchOrderRequest(input).execute();
    }

    public CompletableFuture<ApiResponse<Void>> patchOrderAsync(PatchOrderInput input) {
        try {
            return this.preparePatchOrderRequest(input).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ApiResponse<Void>, ApiException> preparePatchOrderRequest(PatchOrderInput input) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/checkout/orders/{id}").bodyParam(param -> param.value(input.getBody()).isRequired(false)).bodySerializer(() -> ApiHelper.serialize(input.getBody())).templateParam(param -> param.key("id").value((Object)input.getId()).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("PayPal-Mock-Response").value((Object)input.getPaypalMockResponse()).isRequired(false)).headerParam(param -> param.key("PayPal-Auth-Assertion").value((Object)input.getPaypalAuthAssertion()).isRequired(false)).withAuth(auth -> auth.add("Oauth2")).httpMethod((Method)HttpMethod.PATCH)).responseHandler(responseHandler -> responseHandler.responseClassType(ResponseClassType.API_RESPONSE).nullify404(false).localErrorCase("400", ErrorCase.setReason((String)"Request is not well-formed, syntactically incorrect, or violates schema.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("401", ErrorCase.setReason((String)"Authentication failed due to missing authorization header, or invalid authentication credentials.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("404", ErrorCase.setReason((String)"The specified resource does not exist.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("422", ErrorCase.setReason((String)"The requested action could not be performed, semantically incorrect, or failed business validation.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("DEFAULT", ErrorCase.setReason((String)"The error response.", (reason, context) -> new ErrorException(reason, context))).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    public ApiResponse<OrderAuthorizeResponse> authorizeOrder(AuthorizeOrderInput input) throws ApiException, IOException {
        return (ApiResponse)this.prepareAuthorizeOrderRequest(input).execute();
    }

    public CompletableFuture<ApiResponse<OrderAuthorizeResponse>> authorizeOrderAsync(AuthorizeOrderInput input) {
        try {
            return this.prepareAuthorizeOrderRequest(input).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ApiResponse<OrderAuthorizeResponse>, ApiException> prepareAuthorizeOrderRequest(AuthorizeOrderInput input) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/checkout/orders/{id}/authorize").bodyParam(param -> param.value((Object)input.getBody()).isRequired(false)).bodySerializer(() -> ApiHelper.serialize((Object)input.getBody())).templateParam(param -> param.key("id").value((Object)input.getId()).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("PayPal-Mock-Response").value((Object)input.getPaypalMockResponse()).isRequired(false)).headerParam(param -> param.key("PayPal-Request-Id").value((Object)input.getPaypalRequestId()).isRequired(false)).headerParam(param -> param.key("Prefer").value((Object)input.getPrefer()).isRequired(false)).headerParam(param -> param.key("PayPal-Client-Metadata-Id").value((Object)input.getPaypalClientMetadataId()).isRequired(false)).headerParam(param -> param.key("PayPal-Auth-Assertion").value((Object)input.getPaypalAuthAssertion()).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).withAuth(auth -> auth.add("Oauth2")).httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.responseClassType(ResponseClassType.API_RESPONSE).apiResponseDeserializer(response -> (OrderAuthorizeResponse)ApiHelper.deserialize((String)response, OrderAuthorizeResponse.class)).nullify404(false).localErrorCase("400", ErrorCase.setReason((String)"Request is not well-formed, syntactically incorrect, or violates schema.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("401", ErrorCase.setReason((String)"Authentication failed due to missing authorization header, or invalid authentication credentials.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("403", ErrorCase.setReason((String)"The authorized payment failed due to insufficient permissions.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("404", ErrorCase.setReason((String)"The specified resource does not exist.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("422", ErrorCase.setReason((String)"The requested action could not be performed, semantically incorrect, or failed business validation.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("500", ErrorCase.setReason((String)"An internal server error has occurred.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("DEFAULT", ErrorCase.setReason((String)"The error response.", (reason, context) -> new ErrorException(reason, context))).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    public ApiResponse<Void> updateOrderTracking(UpdateOrderTrackingInput input) throws ApiException, IOException {
        return (ApiResponse)this.prepareUpdateOrderTrackingRequest(input).execute();
    }

    public CompletableFuture<ApiResponse<Void>> updateOrderTrackingAsync(UpdateOrderTrackingInput input) {
        try {
            return this.prepareUpdateOrderTrackingRequest(input).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ApiResponse<Void>, ApiException> prepareUpdateOrderTrackingRequest(UpdateOrderTrackingInput input) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/checkout/orders/{id}/trackers/{tracker_id}").bodyParam(param -> param.value(input.getBody()).isRequired(false)).bodySerializer(() -> ApiHelper.serialize(input.getBody())).templateParam(param -> param.key("id").value((Object)input.getId()).shouldEncode(true)).templateParam(param -> param.key("tracker_id").value((Object)input.getTrackerId()).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("PayPal-Auth-Assertion").value((Object)input.getPaypalAuthAssertion()).isRequired(false)).withAuth(auth -> auth.add("Oauth2")).httpMethod((Method)HttpMethod.PATCH)).responseHandler(responseHandler -> responseHandler.responseClassType(ResponseClassType.API_RESPONSE).nullify404(false).localErrorCase("400", ErrorCase.setReason((String)"Request is not well-formed, syntactically incorrect, or violates schema.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("403", ErrorCase.setReason((String)"Authorization failed due to insufficient permissions.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("404", ErrorCase.setReason((String)"The specified resource does not exist.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("422", ErrorCase.setReason((String)"The requested action could not be performed, semantically incorrect, or failed business validation.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("500", ErrorCase.setReason((String)"An internal server error has occurred.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("DEFAULT", ErrorCase.setReason((String)"The error response.", (reason, context) -> new ErrorException(reason, context))).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    public ApiResponse<Order> createOrderTracking(CreateOrderTrackingInput input) throws ApiException, IOException {
        return (ApiResponse)this.prepareCreateOrderTrackingRequest(input).execute();
    }

    public CompletableFuture<ApiResponse<Order>> createOrderTrackingAsync(CreateOrderTrackingInput input) {
        try {
            return this.prepareCreateOrderTrackingRequest(input).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ApiResponse<Order>, ApiException> prepareCreateOrderTrackingRequest(CreateOrderTrackingInput input) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/checkout/orders/{id}/track").bodyParam(param -> param.value((Object)input.getBody())).bodySerializer(() -> ApiHelper.serialize((Object)input.getBody())).templateParam(param -> param.key("id").value((Object)input.getId()).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("PayPal-Auth-Assertion").value((Object)input.getPaypalAuthAssertion()).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).withAuth(auth -> auth.add("Oauth2")).httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.responseClassType(ResponseClassType.API_RESPONSE).apiResponseDeserializer(response -> (Order)ApiHelper.deserialize((String)response, Order.class)).nullify404(false).localErrorCase("400", ErrorCase.setReason((String)"Request is not well-formed, syntactically incorrect, or violates schema.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("403", ErrorCase.setReason((String)"Authorization failed due to insufficient permissions.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("404", ErrorCase.setReason((String)"The specified resource does not exist.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("422", ErrorCase.setReason((String)"The requested action could not be performed, semantically incorrect, or failed business validation.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("500", ErrorCase.setReason((String)"An internal server error has occurred.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("DEFAULT", ErrorCase.setReason((String)"The error response.", (reason, context) -> new ErrorException(reason, context))).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    public ApiResponse<Order> createOrder(CreateOrderInput input) throws ApiException, IOException {
        return (ApiResponse)this.prepareCreateOrderRequest(input).execute();
    }

    public CompletableFuture<ApiResponse<Order>> createOrderAsync(CreateOrderInput input) {
        try {
            return this.prepareCreateOrderRequest(input).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ApiResponse<Order>, ApiException> prepareCreateOrderRequest(CreateOrderInput input) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/checkout/orders").bodyParam(param -> param.value((Object)input.getBody())).bodySerializer(() -> ApiHelper.serialize((Object)input.getBody())).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("PayPal-Mock-Response").value((Object)input.getPaypalMockResponse()).isRequired(false)).headerParam(param -> param.key("PayPal-Request-Id").value((Object)input.getPaypalRequestId()).isRequired(false)).headerParam(param -> param.key("PayPal-Partner-Attribution-Id").value((Object)input.getPaypalPartnerAttributionId()).isRequired(false)).headerParam(param -> param.key("PayPal-Client-Metadata-Id").value((Object)input.getPaypalClientMetadataId()).isRequired(false)).headerParam(param -> param.key("Prefer").value((Object)input.getPrefer()).isRequired(false)).headerParam(param -> param.key("PayPal-Auth-Assertion").value((Object)input.getPaypalAuthAssertion()).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).withAuth(auth -> auth.add("Oauth2")).httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.responseClassType(ResponseClassType.API_RESPONSE).apiResponseDeserializer(response -> (Order)ApiHelper.deserialize((String)response, Order.class)).nullify404(false).localErrorCase("400", ErrorCase.setReason((String)"Request is not well-formed, syntactically incorrect, or violates schema.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("401", ErrorCase.setReason((String)"Authentication failed due to missing authorization header, or invalid authentication credentials.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("422", ErrorCase.setReason((String)"The requested action could not be performed, semantically incorrect, or failed business validation.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("DEFAULT", ErrorCase.setReason((String)"The error response.", (reason, context) -> new ErrorException(reason, context))).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    public ApiResponse<Order> captureOrder(CaptureOrderInput input) throws ApiException, IOException {
        return (ApiResponse)this.prepareCaptureOrderRequest(input).execute();
    }

    public CompletableFuture<ApiResponse<Order>> captureOrderAsync(CaptureOrderInput input) {
        try {
            return this.prepareCaptureOrderRequest(input).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ApiResponse<Order>, ApiException> prepareCaptureOrderRequest(CaptureOrderInput input) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/checkout/orders/{id}/capture").bodyParam(param -> param.value((Object)input.getBody()).isRequired(false)).bodySerializer(() -> ApiHelper.serialize((Object)input.getBody())).templateParam(param -> param.key("id").value((Object)input.getId()).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("PayPal-Mock-Response").value((Object)input.getPaypalMockResponse()).isRequired(false)).headerParam(param -> param.key("PayPal-Request-Id").value((Object)input.getPaypalRequestId()).isRequired(false)).headerParam(param -> param.key("Prefer").value((Object)input.getPrefer()).isRequired(false)).headerParam(param -> param.key("PayPal-Client-Metadata-Id").value((Object)input.getPaypalClientMetadataId()).isRequired(false)).headerParam(param -> param.key("PayPal-Auth-Assertion").value((Object)input.getPaypalAuthAssertion()).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).withAuth(auth -> auth.add("Oauth2")).httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.responseClassType(ResponseClassType.API_RESPONSE).apiResponseDeserializer(response -> (Order)ApiHelper.deserialize((String)response, Order.class)).nullify404(false).localErrorCase("400", ErrorCase.setReason((String)"Request is not well-formed, syntactically incorrect, or violates schema.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("401", ErrorCase.setReason((String)"Authentication failed due to missing authorization header, or invalid authentication credentials.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("403", ErrorCase.setReason((String)"The authorized payment failed due to insufficient permissions.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("404", ErrorCase.setReason((String)"The specified resource does not exist.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("422", ErrorCase.setReason((String)"The requested action could not be performed, semantically incorrect, or failed business validation.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("500", ErrorCase.setReason((String)"An internal server error has occurred.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("DEFAULT", ErrorCase.setReason((String)"The error response.", (reason, context) -> new ErrorException(reason, context))).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    public ApiResponse<Order> getOrder(GetOrderInput input) throws ApiException, IOException {
        return (ApiResponse)this.prepareGetOrderRequest(input).execute();
    }

    public CompletableFuture<ApiResponse<Order>> getOrderAsync(GetOrderInput input) {
        try {
            return this.prepareGetOrderRequest(input).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ApiResponse<Order>, ApiException> prepareGetOrderRequest(GetOrderInput input) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/checkout/orders/{id}").queryParam(param -> param.key("fields").value((Object)input.getFields()).isRequired(false)).templateParam(param -> param.key("id").value((Object)input.getId()).shouldEncode(true)).headerParam(param -> param.key("PayPal-Mock-Response").value((Object)input.getPaypalMockResponse()).isRequired(false)).headerParam(param -> param.key("PayPal-Auth-Assertion").value((Object)input.getPaypalAuthAssertion()).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).withAuth(auth -> auth.add("Oauth2")).httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.responseClassType(ResponseClassType.API_RESPONSE).apiResponseDeserializer(response -> (Order)ApiHelper.deserialize((String)response, Order.class)).nullify404(false).localErrorCase("401", ErrorCase.setReason((String)"Authentication failed due to missing authorization header, or invalid authentication credentials.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("404", ErrorCase.setReason((String)"The specified resource does not exist.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("DEFAULT", ErrorCase.setReason((String)"The error response.", (reason, context) -> new ErrorException(reason, context))).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    public ApiResponse<Order> confirmOrder(ConfirmOrderInput input) throws ApiException, IOException {
        return (ApiResponse)this.prepareConfirmOrderRequest(input).execute();
    }

    public CompletableFuture<ApiResponse<Order>> confirmOrderAsync(ConfirmOrderInput input) {
        try {
            return this.prepareConfirmOrderRequest(input).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ApiResponse<Order>, ApiException> prepareConfirmOrderRequest(ConfirmOrderInput input) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/checkout/orders/{id}/confirm-payment-source").bodyParam(param -> param.value((Object)input.getBody()).isRequired(false)).bodySerializer(() -> ApiHelper.serialize((Object)input.getBody())).templateParam(param -> param.key("id").value((Object)input.getId()).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("PayPal-Client-Metadata-Id").value((Object)input.getPaypalClientMetadataId()).isRequired(false)).headerParam(param -> param.key("PayPal-Auth-Assertion").value((Object)input.getPaypalAuthAssertion()).isRequired(false)).headerParam(param -> param.key("Prefer").value((Object)input.getPrefer()).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).withAuth(auth -> auth.add("Oauth2")).httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.responseClassType(ResponseClassType.API_RESPONSE).apiResponseDeserializer(response -> (Order)ApiHelper.deserialize((String)response, Order.class)).nullify404(false).localErrorCase("400", ErrorCase.setReason((String)"Request is not well-formed, syntactically incorrect, or violates schema.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("403", ErrorCase.setReason((String)"Authorization failed due to insufficient permissions.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("422", ErrorCase.setReason((String)"The requested action could not be performed, semantically incorrect, or failed business validation.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("500", ErrorCase.setReason((String)"An internal server error has occurred.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("DEFAULT", ErrorCase.setReason((String)"The error response.", (reason, context) -> new ErrorException(reason, context))).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }
}

