/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.authentication;

import com.paypal.sdk.ClientCredentialsAuth;
import com.paypal.sdk.authentication.ClientCredentialsAuthModel;
import com.paypal.sdk.controllers.OAuthAuthorizationController;
import com.paypal.sdk.exceptions.ApiException;
import com.paypal.sdk.models.OAuthToken;
import com.paypal.sdk.models.RequestTokenInput;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.core.authentication.HeaderAuth;
import io.apimatic.coreinterfaces.http.request.Request;
import java.io.IOException;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class ClientCredentialsAuthManager
extends HeaderAuth
implements ClientCredentialsAuth {
    private OAuthAuthorizationController oAuthApi;
    private ClientCredentialsAuthModel authModel;
    private OAuthToken oAuthToken;
    private static final Object lockObj = new Object();

    public ClientCredentialsAuthManager(ClientCredentialsAuthModel authModel) {
        super(Collections.emptyMap());
        this.authModel = authModel;
        this.oAuthToken = authModel.getOAuthToken();
    }

    public void applyGlobalConfiguration(GlobalConfiguration config) {
        this.oAuthApi = new OAuthAuthorizationController(config);
    }

    @Override
    public String getOAuthClientId() {
        return this.authModel.getOAuthClientId();
    }

    @Override
    public String getOAuthClientSecret() {
        return this.authModel.getOAuthClientSecret();
    }

    @Override
    public OAuthToken getOAuthToken() {
        return this.authModel.getOAuthToken();
    }

    @Override
    public boolean equals(String oAuthClientId, String oAuthClientSecret, OAuthToken oAuthToken) {
        return oAuthClientId.equals(this.getOAuthClientId()) && oAuthClientSecret.equals(this.getOAuthClientSecret()) && (this.getOAuthToken() == null && oAuthToken == null || this.getOAuthToken() != null && oAuthToken != null && oAuthToken.toString().equals(this.getOAuthToken().toString()));
    }

    public String toString() {
        return "ClientCredentialsAuthManager [oAuthClientId=" + this.getOAuthClientId() + ", oAuthClientSecret=" + this.getOAuthClientSecret() + ", oAuthToken=" + this.getOAuthToken() + "]";
    }

    @Override
    public CompletableFuture<OAuthToken> fetchTokenAsync(Map<String, Object> additionalParameters) {
        HashMap<String, Object> aparams = additionalParameters == null ? new HashMap<String, Object>() : additionalParameters;
        RequestTokenInput input = new RequestTokenInput.Builder().authorization(this.getBasicAuthForClient()).scope(null).build();
        return this.oAuthApi.requestTokenAsync(input, aparams).thenApply(result -> {
            OAuthToken token = (OAuthToken)result.getResult();
            Long expiresIn = token.getExpiresIn();
            if (expiresIn != null && expiresIn != 0L) {
                token.setExpiry(System.currentTimeMillis() / 1000L + token.getExpiresIn());
            }
            return token;
        });
    }

    @Override
    public CompletableFuture<OAuthToken> fetchTokenAsync() {
        return this.fetchTokenAsync(null);
    }

    @Override
    public OAuthToken fetchToken(Map<String, Object> additionalParameters) throws ApiException, IOException {
        HashMap<String, Object> aparams = additionalParameters == null ? new HashMap<String, Object>() : additionalParameters;
        RequestTokenInput input = new RequestTokenInput.Builder().authorization(this.getBasicAuthForClient()).scope(null).build();
        OAuthToken token = this.oAuthApi.requestToken(input, aparams).getResult();
        if (token.getExpiresIn() != null && token.getExpiresIn() != 0L) {
            token.setExpiry(System.currentTimeMillis() / 1000L + token.getExpiresIn());
        }
        return token;
    }

    @Override
    public OAuthToken fetchToken() throws ApiException, IOException {
        return this.fetchToken(null);
    }

    private String getBasicAuthForClient() {
        String val = this.getOAuthClientId() + ":" + this.getOAuthClientSecret();
        return "Basic " + new String(Base64.getEncoder().encodeToString(val.getBytes()));
    }

    @Override
    public boolean isTokenExpired() {
        return this.isTokenExpired(this.getOAuthToken());
    }

    @Override
    public boolean isTokenExpired(OAuthToken oAuthToken) {
        if (oAuthToken == null) {
            throw new IllegalStateException("OAuth token is missing.");
        }
        return oAuthToken.getExpiry() != null && oAuthToken.getExpiry() - this.authModel.getOAuthClockSkew() < System.currentTimeMillis() / 1000L;
    }

    private OAuthToken getTokenFromProvider() {
        if (this.oAuthToken != null && !this.isTokenExpired(this.oAuthToken)) {
            return this.oAuthToken;
        }
        if (this.authModel.getOAuthTokenProvider() != null) {
            OAuthToken token = this.authModel.getOAuthTokenProvider().apply(this.oAuthToken, this);
            this.applyOnTokenUpdateCallback(token);
            return token;
        }
        try {
            OAuthToken token = this.fetchToken();
            this.applyOnTokenUpdateCallback(token);
            return token;
        }
        catch (ApiException | IOException e) {
            return this.oAuthToken;
        }
    }

    private void applyOnTokenUpdateCallback(OAuthToken token) {
        if (this.authModel.getOAuthOnTokenUpdate() != null) {
            this.authModel.getOAuthOnTokenUpdate().accept(token.toBuilder().build());
        }
    }

    private static String getAuthorizationHeader(OAuthToken token) {
        if (token == null) {
            return null;
        }
        return "Bearer " + token.getAccessToken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() {
        Object object = lockObj;
        synchronized (object) {
            this.oAuthToken = this.getTokenFromProvider();
            if (this.oAuthToken == null) {
                this.setErrorMessage("Client is not authorized. An OAuth token is needed to make API calls.");
                this.setValidity(false);
            } else if (this.isTokenExpired(this.oAuthToken)) {
                this.setErrorMessage("The oAuth token is expired. A valid token is needed to make API calls.");
                this.setValidity(false);
            } else {
                this.setValidity(true);
            }
        }
    }

    public Request apply(Request httpRequest) {
        httpRequest.getHeaders().remove("Authorization");
        httpRequest.getHeaders().add("Authorization", ClientCredentialsAuthManager.getAuthorizationHeader(this.oAuthToken));
        return httpRequest;
    }

    public String getErrorMessage() {
        String errorMessage = super.getErrorMessage();
        if (errorMessage == null) {
            return null;
        }
        return "ClientCredentialsAuth - " + errorMessage;
    }
}

