/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.Money;
import com.paypal.sdk.models.RefundPaymentInstruction;

public class RefundRequest {
    private Money amount;
    private String customId;
    private String invoiceId;
    private String noteToPayer;
    private RefundPaymentInstruction paymentInstruction;

    public RefundRequest() {
    }

    public RefundRequest(Money amount, String customId, String invoiceId, String noteToPayer, RefundPaymentInstruction paymentInstruction) {
        this.amount = amount;
        this.customId = customId;
        this.invoiceId = invoiceId;
        this.noteToPayer = noteToPayer;
        this.paymentInstruction = paymentInstruction;
    }

    @JsonGetter(value="amount")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAmount() {
        return this.amount;
    }

    @JsonSetter(value="amount")
    public void setAmount(Money amount) {
        this.amount = amount;
    }

    @JsonGetter(value="custom_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCustomId() {
        return this.customId;
    }

    @JsonSetter(value="custom_id")
    public void setCustomId(String customId) {
        this.customId = customId;
    }

    @JsonGetter(value="invoice_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getInvoiceId() {
        return this.invoiceId;
    }

    @JsonSetter(value="invoice_id")
    public void setInvoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
    }

    @JsonGetter(value="note_to_payer")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getNoteToPayer() {
        return this.noteToPayer;
    }

    @JsonSetter(value="note_to_payer")
    public void setNoteToPayer(String noteToPayer) {
        this.noteToPayer = noteToPayer;
    }

    @JsonGetter(value="payment_instruction")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public RefundPaymentInstruction getPaymentInstruction() {
        return this.paymentInstruction;
    }

    @JsonSetter(value="payment_instruction")
    public void setPaymentInstruction(RefundPaymentInstruction paymentInstruction) {
        this.paymentInstruction = paymentInstruction;
    }

    public String toString() {
        return "RefundRequest [amount=" + this.amount + ", customId=" + this.customId + ", invoiceId=" + this.invoiceId + ", noteToPayer=" + this.noteToPayer + ", paymentInstruction=" + this.paymentInstruction + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().amount(this.getAmount()).customId(this.getCustomId()).invoiceId(this.getInvoiceId()).noteToPayer(this.getNoteToPayer()).paymentInstruction(this.getPaymentInstruction());
        return builder;
    }

    public static class Builder {
        private Money amount;
        private String customId;
        private String invoiceId;
        private String noteToPayer;
        private RefundPaymentInstruction paymentInstruction;

        public Builder amount(Money amount) {
            this.amount = amount;
            return this;
        }

        public Builder customId(String customId) {
            this.customId = customId;
            return this;
        }

        public Builder invoiceId(String invoiceId) {
            this.invoiceId = invoiceId;
            return this;
        }

        public Builder noteToPayer(String noteToPayer) {
            this.noteToPayer = noteToPayer;
            return this;
        }

        public Builder paymentInstruction(RefundPaymentInstruction paymentInstruction) {
            this.paymentInstruction = paymentInstruction;
            return this;
        }

        public RefundRequest build() {
            return new RefundRequest(this.amount, this.customId, this.invoiceId, this.noteToPayer, this.paymentInstruction);
        }
    }
}

