/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.OrderUpdateCallbackShippingAddress;
import com.paypal.sdk.models.OrderUpdateCallbackShippingOption;
import com.paypal.sdk.models.PurchaseUnitRequest;
import java.util.List;

public class OrderUpdateCallbackRequest {
    private String id;
    private OrderUpdateCallbackShippingAddress shippingAddress;
    private OrderUpdateCallbackShippingOption shippingOption;
    private List<PurchaseUnitRequest> purchaseUnits;

    public OrderUpdateCallbackRequest() {
    }

    public OrderUpdateCallbackRequest(OrderUpdateCallbackShippingAddress shippingAddress, List<PurchaseUnitRequest> purchaseUnits, String id, OrderUpdateCallbackShippingOption shippingOption) {
        this.id = id;
        this.shippingAddress = shippingAddress;
        this.shippingOption = shippingOption;
        this.purchaseUnits = purchaseUnits;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonSetter(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonGetter(value="shipping_address")
    public OrderUpdateCallbackShippingAddress getShippingAddress() {
        return this.shippingAddress;
    }

    @JsonSetter(value="shipping_address")
    public void setShippingAddress(OrderUpdateCallbackShippingAddress shippingAddress) {
        this.shippingAddress = shippingAddress;
    }

    @JsonGetter(value="shipping_option")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public OrderUpdateCallbackShippingOption getShippingOption() {
        return this.shippingOption;
    }

    @JsonSetter(value="shipping_option")
    public void setShippingOption(OrderUpdateCallbackShippingOption shippingOption) {
        this.shippingOption = shippingOption;
    }

    @JsonGetter(value="purchase_units")
    public List<PurchaseUnitRequest> getPurchaseUnits() {
        return this.purchaseUnits;
    }

    @JsonSetter(value="purchase_units")
    public void setPurchaseUnits(List<PurchaseUnitRequest> purchaseUnits) {
        this.purchaseUnits = purchaseUnits;
    }

    public String toString() {
        return "OrderUpdateCallbackRequest [shippingAddress=" + this.shippingAddress + ", purchaseUnits=" + this.purchaseUnits + ", id=" + this.id + ", shippingOption=" + this.shippingOption + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.shippingAddress, this.purchaseUnits).id(this.getId()).shippingOption(this.getShippingOption());
        return builder;
    }

    public static class Builder {
        private OrderUpdateCallbackShippingAddress shippingAddress;
        private List<PurchaseUnitRequest> purchaseUnits;
        private String id;
        private OrderUpdateCallbackShippingOption shippingOption;

        public Builder() {
        }

        public Builder(OrderUpdateCallbackShippingAddress shippingAddress, List<PurchaseUnitRequest> purchaseUnits) {
            this.shippingAddress = shippingAddress;
            this.purchaseUnits = purchaseUnits;
        }

        public Builder shippingAddress(OrderUpdateCallbackShippingAddress shippingAddress) {
            this.shippingAddress = shippingAddress;
            return this;
        }

        public Builder purchaseUnits(List<PurchaseUnitRequest> purchaseUnits) {
            this.purchaseUnits = purchaseUnits;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder shippingOption(OrderUpdateCallbackShippingOption shippingOption) {
            this.shippingOption = shippingOption;
            return this;
        }

        public OrderUpdateCallbackRequest build() {
            return new OrderUpdateCallbackRequest(this.shippingAddress, this.purchaseUnits, this.id, this.shippingOption);
        }
    }
}

