/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public enum OAuthProviderError {
    INVALID_REQUEST,
    INVALID_CLIENT,
    INVALID_GRANT,
    UNAUTHORIZED_CLIENT,
    UNSUPPORTED_GRANT_TYPE,
    INVALID_SCOPE;

    private static TreeMap<String, OAuthProviderError> valueMap;
    private String value;

    @JsonCreator
    public static OAuthProviderError constructFromString(String toConvert) throws IOException {
        OAuthProviderError enumValue = OAuthProviderError.fromString(toConvert);
        if (enumValue == null) {
            throw new IOException("Unable to create enum instance with value: " + toConvert);
        }
        return enumValue;
    }

    public static OAuthProviderError fromString(String toConvert) {
        return valueMap.get(toConvert);
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public String toString() {
        return this.value.toString();
    }

    public static List<String> toValue(List<OAuthProviderError> toConvert) {
        if (toConvert == null) {
            return null;
        }
        ArrayList<String> convertedValues = new ArrayList<String>();
        for (OAuthProviderError enumValue : toConvert) {
            convertedValues.add(enumValue.value);
        }
        return convertedValues;
    }

    static {
        valueMap = new TreeMap();
        OAuthProviderError.INVALID_REQUEST.value = "invalid_request";
        OAuthProviderError.INVALID_CLIENT.value = "invalid_client";
        OAuthProviderError.INVALID_GRANT.value = "invalid_grant";
        OAuthProviderError.UNAUTHORIZED_CLIENT.value = "unauthorized_client";
        OAuthProviderError.UNSUPPORTED_GRANT_TYPE.value = "unsupported_grant_type";
        OAuthProviderError.INVALID_SCOPE.value = "invalid_scope";
        valueMap.put("invalid_request", INVALID_REQUEST);
        valueMap.put("invalid_client", INVALID_CLIENT);
        valueMap.put("invalid_grant", INVALID_GRANT);
        valueMap.put("unauthorized_client", UNAUTHORIZED_CLIENT);
        valueMap.put("unsupported_grant_type", UNSUPPORTED_GRANT_TYPE);
        valueMap.put("invalid_scope", INVALID_SCOPE);
    }
}

