/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public enum CardType {
    CREDIT,
    DEBIT,
    PREPAID,
    STORE,
    UNKNOWN,
    _UNKNOWN;

    private static TreeMap<String, CardType> valueMap;
    private String value;

    @JsonCreator
    public static CardType constructFromString(String toConvert) throws IOException {
        CardType enumValue = CardType.fromString(toConvert);
        if (enumValue == null) {
            throw new IOException("Unable to create enum instance with value: " + toConvert);
        }
        return enumValue;
    }

    public static CardType fromString(String toConvert) {
        if (!valueMap.containsKey(toConvert)) {
            return _UNKNOWN;
        }
        return valueMap.get(toConvert);
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public String toString() {
        if (this.value == null) {
            return null;
        }
        return this.value.toString();
    }

    public static List<String> toValue(List<CardType> toConvert) {
        if (toConvert == null) {
            return null;
        }
        ArrayList<String> convertedValues = new ArrayList<String>();
        for (CardType enumValue : toConvert) {
            convertedValues.add(enumValue.value);
        }
        return convertedValues;
    }

    static {
        valueMap = new TreeMap();
        CardType.CREDIT.value = "CREDIT";
        CardType.DEBIT.value = "DEBIT";
        CardType.PREPAID.value = "PREPAID";
        CardType.STORE.value = "STORE";
        CardType.UNKNOWN.value = "UNKNOWN";
        CardType._UNKNOWN.value = null;
        valueMap.put("CREDIT", CREDIT);
        valueMap.put("DEBIT", DEBIT);
        valueMap.put("PREPAID", PREPAID);
        valueMap.put("STORE", STORE);
        valueMap.put("UNKNOWN", UNKNOWN);
    }
}

