/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for VenmoWalletResponse type.
 */
public class VenmoWalletResponse {
    private String emailAddress;
    private String accountId;
    private String userName;
    private Name name;
    private PhoneNumber phoneNumber;
    private Address address;
    private VenmoWalletAttributesResponse attributes;

    /**
     * Default constructor.
     */
    public VenmoWalletResponse() {
    }

    /**
     * Initialization constructor.
     * @param  emailAddress  String value for emailAddress.
     * @param  accountId  String value for accountId.
     * @param  userName  String value for userName.
     * @param  name  Name value for name.
     * @param  phoneNumber  PhoneNumber value for phoneNumber.
     * @param  address  Address value for address.
     * @param  attributes  VenmoWalletAttributesResponse value for attributes.
     */
    public VenmoWalletResponse(
            String emailAddress,
            String accountId,
            String userName,
            Name name,
            PhoneNumber phoneNumber,
            Address address,
            VenmoWalletAttributesResponse attributes) {
        this.emailAddress = emailAddress;
        this.accountId = accountId;
        this.userName = userName;
        this.name = name;
        this.phoneNumber = phoneNumber;
        this.address = address;
        this.attributes = attributes;
    }

    /**
     * Getter for EmailAddress.
     * The internationalized email address. Note: Up to 64 characters are allowed before and 255
     * characters are allowed after the {@literal @} sign. However, the generally accepted maximum length for
     * an email address is 254 characters. The pattern verifies that an unquoted {@literal @} sign exists.
     * @return Returns the String
     */
    @JsonGetter("email_address")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getEmailAddress() {
        return emailAddress;
    }

    /**
     * Setter for EmailAddress.
     * The internationalized email address. Note: Up to 64 characters are allowed before and 255
     * characters are allowed after the {@literal @} sign. However, the generally accepted maximum length for
     * an email address is 254 characters. The pattern verifies that an unquoted {@literal @} sign exists.
     * @param emailAddress Value for String
     */
    @JsonSetter("email_address")
    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    /**
     * Getter for AccountId.
     * The PayPal payer ID, which is a masked version of the PayPal account number intended for use
     * with third parties. The account number is reversibly encrypted and a proprietary variant of
     * Base32 is used to encode the result.
     * @return Returns the String
     */
    @JsonGetter("account_id")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getAccountId() {
        return accountId;
    }

    /**
     * Setter for AccountId.
     * The PayPal payer ID, which is a masked version of the PayPal account number intended for use
     * with third parties. The account number is reversibly encrypted and a proprietary variant of
     * Base32 is used to encode the result.
     * @param accountId Value for String
     */
    @JsonSetter("account_id")
    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    /**
     * Getter for UserName.
     * The Venmo user name chosen by the user, also know as a Venmo handle.
     * @return Returns the String
     */
    @JsonGetter("user_name")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getUserName() {
        return userName;
    }

    /**
     * Setter for UserName.
     * The Venmo user name chosen by the user, also know as a Venmo handle.
     * @param userName Value for String
     */
    @JsonSetter("user_name")
    public void setUserName(String userName) {
        this.userName = userName;
    }

    /**
     * Getter for Name.
     * The name of the party.
     * @return Returns the Name
     */
    @JsonGetter("name")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Name getName() {
        return name;
    }

    /**
     * Setter for Name.
     * The name of the party.
     * @param name Value for Name
     */
    @JsonSetter("name")
    public void setName(Name name) {
        this.name = name;
    }

    /**
     * Getter for PhoneNumber.
     * The phone number in its canonical international [E.164 numbering plan
     * format](https://www.itu.int/rec/T-REC-E.164/en).
     * @return Returns the PhoneNumber
     */
    @JsonGetter("phone_number")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public PhoneNumber getPhoneNumber() {
        return phoneNumber;
    }

    /**
     * Setter for PhoneNumber.
     * The phone number in its canonical international [E.164 numbering plan
     * format](https://www.itu.int/rec/T-REC-E.164/en).
     * @param phoneNumber Value for PhoneNumber
     */
    @JsonSetter("phone_number")
    public void setPhoneNumber(PhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    /**
     * Getter for Address.
     * The portable international postal address. Maps to
     * [AddressValidationMetadata](https://github.com/googlei18n/libaddressinput/wiki/AddressValidationMetadata)
     * and HTML 5.1 [Autofilling form controls: the autocomplete
     * attribute](https://www.w3.org/TR/html51/sec-forms.html#autofilling-form-controls-the-autocomplete-attribute).
     * @return Returns the Address
     */
    @JsonGetter("address")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Address getAddress() {
        return address;
    }

    /**
     * Setter for Address.
     * The portable international postal address. Maps to
     * [AddressValidationMetadata](https://github.com/googlei18n/libaddressinput/wiki/AddressValidationMetadata)
     * and HTML 5.1 [Autofilling form controls: the autocomplete
     * attribute](https://www.w3.org/TR/html51/sec-forms.html#autofilling-form-controls-the-autocomplete-attribute).
     * @param address Value for Address
     */
    @JsonSetter("address")
    public void setAddress(Address address) {
        this.address = address;
    }

    /**
     * Getter for Attributes.
     * Additional attributes associated with the use of a Venmo Wallet.
     * @return Returns the VenmoWalletAttributesResponse
     */
    @JsonGetter("attributes")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public VenmoWalletAttributesResponse getAttributes() {
        return attributes;
    }

    /**
     * Setter for Attributes.
     * Additional attributes associated with the use of a Venmo Wallet.
     * @param attributes Value for VenmoWalletAttributesResponse
     */
    @JsonSetter("attributes")
    public void setAttributes(VenmoWalletAttributesResponse attributes) {
        this.attributes = attributes;
    }

    /**
     * Converts this VenmoWalletResponse into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "VenmoWalletResponse [" + "emailAddress=" + emailAddress + ", accountId=" + accountId
                + ", userName=" + userName + ", name=" + name + ", phoneNumber=" + phoneNumber
                + ", address=" + address + ", attributes=" + attributes + "]";
    }

    /**
     * Builds a new {@link VenmoWalletResponse.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link VenmoWalletResponse.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder()
                .emailAddress(getEmailAddress())
                .accountId(getAccountId())
                .userName(getUserName())
                .name(getName())
                .phoneNumber(getPhoneNumber())
                .address(getAddress())
                .attributes(getAttributes());
        return builder;
    }

    /**
     * Class to build instances of {@link VenmoWalletResponse}.
     */
    public static class Builder {
        private String emailAddress;
        private String accountId;
        private String userName;
        private Name name;
        private PhoneNumber phoneNumber;
        private Address address;
        private VenmoWalletAttributesResponse attributes;



        /**
         * Setter for emailAddress.
         * @param  emailAddress  String value for emailAddress.
         * @return Builder
         */
        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        /**
         * Setter for accountId.
         * @param  accountId  String value for accountId.
         * @return Builder
         */
        public Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        /**
         * Setter for userName.
         * @param  userName  String value for userName.
         * @return Builder
         */
        public Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        /**
         * Setter for name.
         * @param  name  Name value for name.
         * @return Builder
         */
        public Builder name(Name name) {
            this.name = name;
            return this;
        }

        /**
         * Setter for phoneNumber.
         * @param  phoneNumber  PhoneNumber value for phoneNumber.
         * @return Builder
         */
        public Builder phoneNumber(PhoneNumber phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        /**
         * Setter for address.
         * @param  address  Address value for address.
         * @return Builder
         */
        public Builder address(Address address) {
            this.address = address;
            return this;
        }

        /**
         * Setter for attributes.
         * @param  attributes  VenmoWalletAttributesResponse value for attributes.
         * @return Builder
         */
        public Builder attributes(VenmoWalletAttributesResponse attributes) {
            this.attributes = attributes;
            return this;
        }

        /**
         * Builds a new {@link VenmoWalletResponse} object using the set fields.
         * @return {@link VenmoWalletResponse}
         */
        public VenmoWalletResponse build() {
            return new VenmoWalletResponse(emailAddress, accountId, userName, name, phoneNumber,
                    address, attributes);
        }
    }
}
