/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for VaultVenmoRequest type.
 */
public class VaultVenmoRequest {
    private String description;
    private UsagePattern usagePattern;
    private VaultedDigitalWalletShippingDetails shipping;
    private Boolean permitMultiplePaymentTokens;
    private PaypalPaymentTokenUsageType usageType;
    private PaypalPaymentTokenCustomerType customerType;
    private VaultVenmoExperienceContext experienceContext;

    /**
     * Default constructor.
     */
    public VaultVenmoRequest() {
        permitMultiplePaymentTokens = false;
    }

    /**
     * Initialization constructor.
     * @param  description  String value for description.
     * @param  usagePattern  UsagePattern value for usagePattern.
     * @param  shipping  VaultedDigitalWalletShippingDetails value for shipping.
     * @param  permitMultiplePaymentTokens  Boolean value for permitMultiplePaymentTokens.
     * @param  usageType  PaypalPaymentTokenUsageType value for usageType.
     * @param  customerType  PaypalPaymentTokenCustomerType value for customerType.
     * @param  experienceContext  VaultVenmoExperienceContext value for experienceContext.
     */
    public VaultVenmoRequest(
            String description,
            UsagePattern usagePattern,
            VaultedDigitalWalletShippingDetails shipping,
            Boolean permitMultiplePaymentTokens,
            PaypalPaymentTokenUsageType usageType,
            PaypalPaymentTokenCustomerType customerType,
            VaultVenmoExperienceContext experienceContext) {
        this.description = description;
        this.usagePattern = usagePattern;
        this.shipping = shipping;
        this.permitMultiplePaymentTokens = permitMultiplePaymentTokens;
        this.usageType = usageType;
        this.customerType = customerType;
        this.experienceContext = experienceContext;
    }

    /**
     * Getter for Description.
     * The description displayed to the consumer on the approval flow for a digital wallet, as well
     * as on the merchant view of the payment token management experience. exp: PayPal.com.
     * @return Returns the String
     */
    @JsonGetter("description")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getDescription() {
        return description;
    }

    /**
     * Setter for Description.
     * The description displayed to the consumer on the approval flow for a digital wallet, as well
     * as on the merchant view of the payment token management experience. exp: PayPal.com.
     * @param description Value for String
     */
    @JsonSetter("description")
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * Getter for UsagePattern.
     * Expected business/charge model for the billing agreement.
     * @return Returns the UsagePattern
     */
    @JsonGetter("usage_pattern")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public UsagePattern getUsagePattern() {
        return usagePattern;
    }

    /**
     * Setter for UsagePattern.
     * Expected business/charge model for the billing agreement.
     * @param usagePattern Value for UsagePattern
     */
    @JsonSetter("usage_pattern")
    public void setUsagePattern(UsagePattern usagePattern) {
        this.usagePattern = usagePattern;
    }

    /**
     * Getter for Shipping.
     * The shipping details.
     * @return Returns the VaultedDigitalWalletShippingDetails
     */
    @JsonGetter("shipping")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public VaultedDigitalWalletShippingDetails getShipping() {
        return shipping;
    }

    /**
     * Setter for Shipping.
     * The shipping details.
     * @param shipping Value for VaultedDigitalWalletShippingDetails
     */
    @JsonSetter("shipping")
    public void setShipping(VaultedDigitalWalletShippingDetails shipping) {
        this.shipping = shipping;
    }

    /**
     * Getter for PermitMultiplePaymentTokens.
     * Create multiple payment tokens for the same payer, merchant/platform combination. Use this
     * when the customer has not logged in at merchant/platform. The payment token thus generated,
     * can then also be used to create the customer account at merchant/platform. Use this also when
     * multiple payment tokens are required for the same payer, different customer at
     * merchant/platform. This helps to identify customers distinctly even though they may share the
     * same PayPal account. This only applies to PayPal payment source.
     * @return Returns the Boolean
     */
    @JsonGetter("permit_multiple_payment_tokens")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Boolean getPermitMultiplePaymentTokens() {
        return permitMultiplePaymentTokens;
    }

    /**
     * Setter for PermitMultiplePaymentTokens.
     * Create multiple payment tokens for the same payer, merchant/platform combination. Use this
     * when the customer has not logged in at merchant/platform. The payment token thus generated,
     * can then also be used to create the customer account at merchant/platform. Use this also when
     * multiple payment tokens are required for the same payer, different customer at
     * merchant/platform. This helps to identify customers distinctly even though they may share the
     * same PayPal account. This only applies to PayPal payment source.
     * @param permitMultiplePaymentTokens Value for Boolean
     */
    @JsonSetter("permit_multiple_payment_tokens")
    public void setPermitMultiplePaymentTokens(Boolean permitMultiplePaymentTokens) {
        this.permitMultiplePaymentTokens = permitMultiplePaymentTokens;
    }

    /**
     * Getter for UsageType.
     * The usage type associated with a digital wallet payment token.
     * @return Returns the PaypalPaymentTokenUsageType
     */
    @JsonGetter("usage_type")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public PaypalPaymentTokenUsageType getUsageType() {
        return usageType;
    }

    /**
     * Setter for UsageType.
     * The usage type associated with a digital wallet payment token.
     * @param usageType Value for PaypalPaymentTokenUsageType
     */
    @JsonSetter("usage_type")
    public void setUsageType(PaypalPaymentTokenUsageType usageType) {
        this.usageType = usageType;
    }

    /**
     * Getter for CustomerType.
     * The customer type associated with a digital wallet payment token. This is to indicate whether
     * the customer acting on the merchant / platform is either a business or a consumer.
     * @return Returns the PaypalPaymentTokenCustomerType
     */
    @JsonGetter("customer_type")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public PaypalPaymentTokenCustomerType getCustomerType() {
        return customerType;
    }

    /**
     * Setter for CustomerType.
     * The customer type associated with a digital wallet payment token. This is to indicate whether
     * the customer acting on the merchant / platform is either a business or a consumer.
     * @param customerType Value for PaypalPaymentTokenCustomerType
     */
    @JsonSetter("customer_type")
    public void setCustomerType(PaypalPaymentTokenCustomerType customerType) {
        this.customerType = customerType;
    }

    /**
     * Getter for ExperienceContext.
     * Customizes the Vault creation flow experience for your customers.
     * @return Returns the VaultVenmoExperienceContext
     */
    @JsonGetter("experience_context")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public VaultVenmoExperienceContext getExperienceContext() {
        return experienceContext;
    }

    /**
     * Setter for ExperienceContext.
     * Customizes the Vault creation flow experience for your customers.
     * @param experienceContext Value for VaultVenmoExperienceContext
     */
    @JsonSetter("experience_context")
    public void setExperienceContext(VaultVenmoExperienceContext experienceContext) {
        this.experienceContext = experienceContext;
    }

    /**
     * Converts this VaultVenmoRequest into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "VaultVenmoRequest [" + "description=" + description + ", usagePattern="
                + usagePattern + ", shipping=" + shipping + ", permitMultiplePaymentTokens="
                + permitMultiplePaymentTokens + ", usageType=" + usageType + ", customerType="
                + customerType + ", experienceContext=" + experienceContext + "]";
    }

    /**
     * Builds a new {@link VaultVenmoRequest.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link VaultVenmoRequest.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder()
                .description(getDescription())
                .usagePattern(getUsagePattern())
                .shipping(getShipping())
                .permitMultiplePaymentTokens(getPermitMultiplePaymentTokens())
                .usageType(getUsageType())
                .customerType(getCustomerType())
                .experienceContext(getExperienceContext());
        return builder;
    }

    /**
     * Class to build instances of {@link VaultVenmoRequest}.
     */
    public static class Builder {
        private String description;
        private UsagePattern usagePattern;
        private VaultedDigitalWalletShippingDetails shipping;
        private Boolean permitMultiplePaymentTokens = false;
        private PaypalPaymentTokenUsageType usageType;
        private PaypalPaymentTokenCustomerType customerType;
        private VaultVenmoExperienceContext experienceContext;



        /**
         * Setter for description.
         * @param  description  String value for description.
         * @return Builder
         */
        public Builder description(String description) {
            this.description = description;
            return this;
        }

        /**
         * Setter for usagePattern.
         * @param  usagePattern  UsagePattern value for usagePattern.
         * @return Builder
         */
        public Builder usagePattern(UsagePattern usagePattern) {
            this.usagePattern = usagePattern;
            return this;
        }

        /**
         * Setter for shipping.
         * @param  shipping  VaultedDigitalWalletShippingDetails value for shipping.
         * @return Builder
         */
        public Builder shipping(VaultedDigitalWalletShippingDetails shipping) {
            this.shipping = shipping;
            return this;
        }

        /**
         * Setter for permitMultiplePaymentTokens.
         * @param  permitMultiplePaymentTokens  Boolean value for permitMultiplePaymentTokens.
         * @return Builder
         */
        public Builder permitMultiplePaymentTokens(Boolean permitMultiplePaymentTokens) {
            this.permitMultiplePaymentTokens = permitMultiplePaymentTokens;
            return this;
        }

        /**
         * Setter for usageType.
         * @param  usageType  PaypalPaymentTokenUsageType value for usageType.
         * @return Builder
         */
        public Builder usageType(PaypalPaymentTokenUsageType usageType) {
            this.usageType = usageType;
            return this;
        }

        /**
         * Setter for customerType.
         * @param  customerType  PaypalPaymentTokenCustomerType value for customerType.
         * @return Builder
         */
        public Builder customerType(PaypalPaymentTokenCustomerType customerType) {
            this.customerType = customerType;
            return this;
        }

        /**
         * Setter for experienceContext.
         * @param  experienceContext  VaultVenmoExperienceContext value for experienceContext.
         * @return Builder
         */
        public Builder experienceContext(VaultVenmoExperienceContext experienceContext) {
            this.experienceContext = experienceContext;
            return this;
        }

        /**
         * Builds a new {@link VaultVenmoRequest} object using the set fields.
         * @return {@link VaultVenmoRequest}
         */
        public VaultVenmoRequest build() {
            return new VaultVenmoRequest(description, usagePattern, shipping,
                    permitMultiplePaymentTokens, usageType, customerType, experienceContext);
        }
    }
}
