/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for SupplementaryPurchaseData type.
 */
public class SupplementaryPurchaseData {
    private String invoiceId;
    private String noteToPayer;

    /**
     * Default constructor.
     */
    public SupplementaryPurchaseData() {
    }

    /**
     * Initialization constructor.
     * @param  invoiceId  String value for invoiceId.
     * @param  noteToPayer  String value for noteToPayer.
     */
    public SupplementaryPurchaseData(
            String invoiceId,
            String noteToPayer) {
        this.invoiceId = invoiceId;
        this.noteToPayer = noteToPayer;
    }

    /**
     * Getter for InvoiceId.
     * The API caller-provided external invoice number for this order. Appears in both the payer's
     * transaction history and the emails that the payer receives.
     * @return Returns the String
     */
    @JsonGetter("invoice_id")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getInvoiceId() {
        return invoiceId;
    }

    /**
     * Setter for InvoiceId.
     * The API caller-provided external invoice number for this order. Appears in both the payer's
     * transaction history and the emails that the payer receives.
     * @param invoiceId Value for String
     */
    @JsonSetter("invoice_id")
    public void setInvoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
    }

    /**
     * Getter for NoteToPayer.
     * An informational note about this settlement. Appears in both the payer's transaction history
     * and the emails that the payer receives.
     * @return Returns the String
     */
    @JsonGetter("note_to_payer")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getNoteToPayer() {
        return noteToPayer;
    }

    /**
     * Setter for NoteToPayer.
     * An informational note about this settlement. Appears in both the payer's transaction history
     * and the emails that the payer receives.
     * @param noteToPayer Value for String
     */
    @JsonSetter("note_to_payer")
    public void setNoteToPayer(String noteToPayer) {
        this.noteToPayer = noteToPayer;
    }

    /**
     * Converts this SupplementaryPurchaseData into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "SupplementaryPurchaseData [" + "invoiceId=" + invoiceId + ", noteToPayer="
                + noteToPayer + "]";
    }

    /**
     * Builds a new {@link SupplementaryPurchaseData.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link SupplementaryPurchaseData.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder()
                .invoiceId(getInvoiceId())
                .noteToPayer(getNoteToPayer());
        return builder;
    }

    /**
     * Class to build instances of {@link SupplementaryPurchaseData}.
     */
    public static class Builder {
        private String invoiceId;
        private String noteToPayer;



        /**
         * Setter for invoiceId.
         * @param  invoiceId  String value for invoiceId.
         * @return Builder
         */
        public Builder invoiceId(String invoiceId) {
            this.invoiceId = invoiceId;
            return this;
        }

        /**
         * Setter for noteToPayer.
         * @param  noteToPayer  String value for noteToPayer.
         * @return Builder
         */
        public Builder noteToPayer(String noteToPayer) {
            this.noteToPayer = noteToPayer;
            return this;
        }

        /**
         * Builds a new {@link SupplementaryPurchaseData} object using the set fields.
         * @return {@link SupplementaryPurchaseData}
         */
        public SupplementaryPurchaseData build() {
            return new SupplementaryPurchaseData(invoiceId, noteToPayer);
        }
    }
}
