/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.utilities.JsonValue;
import java.util.List;

/**
 * This is a model class for Plan type.
 */
public class Plan {
    private List<BillingCycle> billingCycles;
    private JsonValue product;
    private OneTimeCharge oneTimeCharges;
    private String name;

    /**
     * Default constructor.
     */
    public Plan() {
    }

    /**
     * Initialization constructor.
     * @param  billingCycles  List of BillingCycle value for billingCycles.
     * @param  oneTimeCharges  OneTimeCharge value for oneTimeCharges.
     * @param  product  JsonValue value for product.
     * @param  name  String value for name.
     */
    public Plan(
            List<BillingCycle> billingCycles,
            OneTimeCharge oneTimeCharges,
            JsonValue product,
            String name) {
        this.billingCycles = billingCycles;
        this.product = product;
        this.oneTimeCharges = oneTimeCharges;
        this.name = name;
    }

    /**
     * Getter for BillingCycles.
     * An array of billing cycles for trial billing and regular billing. A plan can have at most two
     * trial cycles and only one regular cycle.
     * @return Returns the List of BillingCycle
     */
    @JsonGetter("billing_cycles")
    public List<BillingCycle> getBillingCycles() {
        return billingCycles;
    }

    /**
     * Setter for BillingCycles.
     * An array of billing cycles for trial billing and regular billing. A plan can have at most two
     * trial cycles and only one regular cycle.
     * @param billingCycles Value for List of BillingCycle
     */
    @JsonSetter("billing_cycles")
    public void setBillingCycles(List<BillingCycle> billingCycles) {
        this.billingCycles = billingCycles;
    }

    /**
     * Getter for Product.
     * Product details associated with any one-time product purchase.
     * @return Returns the JsonValue
     */
    @JsonGetter("product")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public JsonValue getProduct() {
        return product;
    }

    /**
     * Setter for Product.
     * Product details associated with any one-time product purchase.
     * @param product Value for JsonValue
     */
    @JsonSetter("product")
    public void setProduct(JsonValue product) {
        this.product = product;
    }

    /**
     * Getter for OneTimeCharges.
     * The one-time charge info at the time of checkout.
     * @return Returns the OneTimeCharge
     */
    @JsonGetter("one_time_charges")
    public OneTimeCharge getOneTimeCharges() {
        return oneTimeCharges;
    }

    /**
     * Setter for OneTimeCharges.
     * The one-time charge info at the time of checkout.
     * @param oneTimeCharges Value for OneTimeCharge
     */
    @JsonSetter("one_time_charges")
    public void setOneTimeCharges(OneTimeCharge oneTimeCharges) {
        this.oneTimeCharges = oneTimeCharges;
    }

    /**
     * Getter for Name.
     * Name of the recurring plan.
     * @return Returns the String
     */
    @JsonGetter("name")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getName() {
        return name;
    }

    /**
     * Setter for Name.
     * Name of the recurring plan.
     * @param name Value for String
     */
    @JsonSetter("name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Converts this Plan into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "Plan [" + "billingCycles=" + billingCycles + ", oneTimeCharges=" + oneTimeCharges
                + ", product=" + product + ", name=" + name + "]";
    }

    /**
     * Builds a new {@link Plan.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link Plan.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder(billingCycles, oneTimeCharges)
                .product(getProduct())
                .name(getName());
        return builder;
    }

    /**
     * Class to build instances of {@link Plan}.
     */
    public static class Builder {
        private List<BillingCycle> billingCycles;
        private OneTimeCharge oneTimeCharges;
        private JsonValue product;
        private String name;

        /**
         * Initialization constructor.
         */
        public Builder() {
        }

        /**
         * Initialization constructor.
         * @param  billingCycles  List of BillingCycle value for billingCycles.
         * @param  oneTimeCharges  OneTimeCharge value for oneTimeCharges.
         */
        public Builder(List<BillingCycle> billingCycles, OneTimeCharge oneTimeCharges) {
            this.billingCycles = billingCycles;
            this.oneTimeCharges = oneTimeCharges;
        }

        /**
         * Setter for billingCycles.
         * @param  billingCycles  List of BillingCycle value for billingCycles.
         * @return Builder
         */
        public Builder billingCycles(List<BillingCycle> billingCycles) {
            this.billingCycles = billingCycles;
            return this;
        }

        /**
         * Setter for oneTimeCharges.
         * @param  oneTimeCharges  OneTimeCharge value for oneTimeCharges.
         * @return Builder
         */
        public Builder oneTimeCharges(OneTimeCharge oneTimeCharges) {
            this.oneTimeCharges = oneTimeCharges;
            return this;
        }

        /**
         * Setter for product.
         * @param  product  JsonValue value for product.
         * @return Builder
         */
        public Builder product(JsonValue product) {
            this.product = product;
            return this;
        }

        /**
         * Setter for name.
         * @param  name  String value for name.
         * @return Builder
         */
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        /**
         * Builds a new {@link Plan} object using the set fields.
         * @return {@link Plan}
         */
        public Plan build() {
            return new Plan(billingCycles, oneTimeCharges, product, name);
        }
    }
}
