/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;


/**
 * PaymentTokenStatus to be used.
 */
public enum PaymentTokenStatus {
    /**
     * A setup token is initialized with minimal information, more data must be added to the setup-token to be vaulted
     */
    CREATED,

    /**
     * A contingecy on payer approval is required before the payment method can be saved.
     */
    PAYER_ACTION_REQUIRED,

    /**
     * Setup token is ready to be vaulted. If a buyer approval contigency was returned, it is has been approved.
     */
    APPROVED,

    /**
     * The payment token has been vaulted.
     */
    VAULTED,

    /**
     * A vaulted payment method token has been tokenized for short term (one time) use.
     */
    TOKENIZED,

    /**
     * Unknown values will be mapped by this enum member
     */
    _UNKNOWN;


    private static TreeMap<String, PaymentTokenStatus> valueMap = new TreeMap<>();
    private String value;

    static {
        CREATED.value = "CREATED";
        PAYER_ACTION_REQUIRED.value = "PAYER_ACTION_REQUIRED";
        APPROVED.value = "APPROVED";
        VAULTED.value = "VAULTED";
        TOKENIZED.value = "TOKENIZED";
        _UNKNOWN.value = null;

        valueMap.put("CREATED", CREATED);
        valueMap.put("PAYER_ACTION_REQUIRED", PAYER_ACTION_REQUIRED);
        valueMap.put("APPROVED", APPROVED);
        valueMap.put("VAULTED", VAULTED);
        valueMap.put("TOKENIZED", TOKENIZED);
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     * @throws IOException when provided value is not mapped to any enum member.
     */
    @JsonCreator
    public static PaymentTokenStatus constructFromString(String toConvert) throws IOException {
        PaymentTokenStatus enumValue = fromString(toConvert);
        if (enumValue == null) {
            throw new IOException("Unable to create enum instance with value: " + toConvert);
        }
        return enumValue;
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     */
    public static PaymentTokenStatus fromString(String toConvert) {
        if (!valueMap.containsKey(toConvert)) {
            return _UNKNOWN;
        }
        return valueMap.get(toConvert);
    }

    /**
     * Returns the string value associated with the enum member.
     * @return The string value against enum member.
     */
    @JsonValue
    public String value() {
        return value;
    }
        
    /**
     * Get string representation of this enum.
     */
    @Override
    public String toString() {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    /**
     * Convert list of PaymentTokenStatus values to list of string values.
     * @param toConvert The list of PaymentTokenStatus values to convert.
     * @return List of representative string values.
     */
    public static List<String> toValue(List<PaymentTokenStatus> toConvert) {
        if (toConvert == null) {
            return null;
        }
        List<String> convertedValues = new ArrayList<>();
        for (PaymentTokenStatus enumValue : toConvert) {
            convertedValues.add(enumValue.value);
        }
        return convertedValues;
    }
} 