/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for OrderUpdateCallbackShippingOption type.
 */
public class OrderUpdateCallbackShippingOption {
    private String id;
    private String label;
    private ShippingType type;
    private Money amount;

    /**
     * Default constructor.
     */
    public OrderUpdateCallbackShippingOption() {
    }

    /**
     * Initialization constructor.
     * @param  id  String value for id.
     * @param  label  String value for label.
     * @param  type  ShippingType value for type.
     * @param  amount  Money value for amount.
     */
    public OrderUpdateCallbackShippingOption(
            String id,
            String label,
            ShippingType type,
            Money amount) {
        this.id = id;
        this.label = label;
        this.type = type;
        this.amount = amount;
    }

    /**
     * Getter for Id.
     * A unique ID that identifies a payer-selected shipping option.
     * @return Returns the String
     */
    @JsonGetter("id")
    public String getId() {
        return id;
    }

    /**
     * Setter for Id.
     * A unique ID that identifies a payer-selected shipping option.
     * @param id Value for String
     */
    @JsonSetter("id")
    public void setId(String id) {
        this.id = id;
    }

    /**
     * Getter for Label.
     * A description that the payer sees, which helps them choose an appropriate shipping option.
     * For example, `Free Shipping`, `USPS Priority Shipping`, `Expédition prioritaire USPS`, or
     * `USPS yōuxiān fā huò`. Localize this description to the payer's locale.
     * @return Returns the String
     */
    @JsonGetter("label")
    public String getLabel() {
        return label;
    }

    /**
     * Setter for Label.
     * A description that the payer sees, which helps them choose an appropriate shipping option.
     * For example, `Free Shipping`, `USPS Priority Shipping`, `Expédition prioritaire USPS`, or
     * `USPS yōuxiān fā huò`. Localize this description to the payer's locale.
     * @param label Value for String
     */
    @JsonSetter("label")
    public void setLabel(String label) {
        this.label = label;
    }

    /**
     * Getter for Type.
     * A classification for the method of purchase fulfillment.
     * @return Returns the ShippingType
     */
    @JsonGetter("type")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public ShippingType getType() {
        return type;
    }

    /**
     * Setter for Type.
     * A classification for the method of purchase fulfillment.
     * @param type Value for ShippingType
     */
    @JsonSetter("type")
    public void setType(ShippingType type) {
        this.type = type;
    }

    /**
     * Getter for Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @return Returns the Money
     */
    @JsonGetter("amount")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Money getAmount() {
        return amount;
    }

    /**
     * Setter for Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @param amount Value for Money
     */
    @JsonSetter("amount")
    public void setAmount(Money amount) {
        this.amount = amount;
    }

    /**
     * Converts this OrderUpdateCallbackShippingOption into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "OrderUpdateCallbackShippingOption [" + "id=" + id + ", label=" + label + ", type="
                + type + ", amount=" + amount + "]";
    }

    /**
     * Builds a new {@link OrderUpdateCallbackShippingOption.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link OrderUpdateCallbackShippingOption.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder(id, label)
                .type(getType())
                .amount(getAmount());
        return builder;
    }

    /**
     * Class to build instances of {@link OrderUpdateCallbackShippingOption}.
     */
    public static class Builder {
        private String id;
        private String label;
        private ShippingType type;
        private Money amount;

        /**
         * Initialization constructor.
         */
        public Builder() {
        }

        /**
         * Initialization constructor.
         * @param  id  String value for id.
         * @param  label  String value for label.
         */
        public Builder(String id, String label) {
            this.id = id;
            this.label = label;
        }

        /**
         * Setter for id.
         * @param  id  String value for id.
         * @return Builder
         */
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        /**
         * Setter for label.
         * @param  label  String value for label.
         * @return Builder
         */
        public Builder label(String label) {
            this.label = label;
            return this;
        }

        /**
         * Setter for type.
         * @param  type  ShippingType value for type.
         * @return Builder
         */
        public Builder type(ShippingType type) {
            this.type = type;
            return this;
        }

        /**
         * Setter for amount.
         * @param  amount  Money value for amount.
         * @return Builder
         */
        public Builder amount(Money amount) {
            this.amount = amount;
            return this;
        }

        /**
         * Builds a new {@link OrderUpdateCallbackShippingOption} object using the set fields.
         * @return {@link OrderUpdateCallbackShippingOption}
         */
        public OrderUpdateCallbackShippingOption build() {
            return new OrderUpdateCallbackShippingOption(id, label, type, amount);
        }
    }
}
