/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.List;

/**
 * This is a model class for OrderUpdateCallbackErrorResponse type.
 */
public class OrderUpdateCallbackErrorResponse {
    private String name;
    private String message;
    private List<OrderUpdateCallbackErrorResponseDetails> details;

    /**
     * Default constructor.
     */
    public OrderUpdateCallbackErrorResponse() {
    }

    /**
     * Initialization constructor.
     * @param  name  String value for name.
     * @param  message  String value for message.
     * @param  details  List of OrderUpdateCallbackErrorResponseDetails value for details.
     */
    public OrderUpdateCallbackErrorResponse(
            String name,
            String message,
            List<OrderUpdateCallbackErrorResponseDetails> details) {
        this.name = name;
        this.message = message;
        this.details = details;
    }

    /**
     * Getter for Name.
     * The human-readable, unique name of the error.
     * @return Returns the String
     */
    @JsonGetter("name")
    public String getName() {
        return name;
    }

    /**
     * Setter for Name.
     * The human-readable, unique name of the error.
     * @param name Value for String
     */
    @JsonSetter("name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Getter for Message.
     * The message that describes the error.
     * @return Returns the String
     */
    @JsonGetter("message")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getMessage() {
        return message;
    }

    /**
     * Setter for Message.
     * The message that describes the error.
     * @param message Value for String
     */
    @JsonSetter("message")
    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * Getter for Details.
     * An array of additional details about the error.
     * @return Returns the List of OrderUpdateCallbackErrorResponseDetails
     */
    @JsonGetter("details")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public List<OrderUpdateCallbackErrorResponseDetails> getDetails() {
        return details;
    }

    /**
     * Setter for Details.
     * An array of additional details about the error.
     * @param details Value for List of OrderUpdateCallbackErrorResponseDetails
     */
    @JsonSetter("details")
    public void setDetails(List<OrderUpdateCallbackErrorResponseDetails> details) {
        this.details = details;
    }

    /**
     * Converts this OrderUpdateCallbackErrorResponse into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "OrderUpdateCallbackErrorResponse [" + "name=" + name + ", message=" + message
                + ", details=" + details + "]";
    }

    /**
     * Builds a new {@link OrderUpdateCallbackErrorResponse.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link OrderUpdateCallbackErrorResponse.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder(name)
                .message(getMessage())
                .details(getDetails());
        return builder;
    }

    /**
     * Class to build instances of {@link OrderUpdateCallbackErrorResponse}.
     */
    public static class Builder {
        private String name;
        private String message;
        private List<OrderUpdateCallbackErrorResponseDetails> details;

        /**
         * Initialization constructor.
         */
        public Builder() {
        }

        /**
         * Initialization constructor.
         * @param  name  String value for name.
         */
        public Builder(String name) {
            this.name = name;
        }

        /**
         * Setter for name.
         * @param  name  String value for name.
         * @return Builder
         */
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        /**
         * Setter for message.
         * @param  message  String value for message.
         * @return Builder
         */
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        /**
         * Setter for details.
         * @param  details  List of OrderUpdateCallbackErrorResponseDetails value for details.
         * @return Builder
         */
        public Builder details(List<OrderUpdateCallbackErrorResponseDetails> details) {
            this.details = details;
            return this;
        }

        /**
         * Builds a new {@link OrderUpdateCallbackErrorResponse} object using the set fields.
         * @return {@link OrderUpdateCallbackErrorResponse}
         */
        public OrderUpdateCallbackErrorResponse build() {
            return new OrderUpdateCallbackErrorResponse(name, message, details);
        }
    }
}
