/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for OneTimeCharge type.
 */
public class OneTimeCharge {
    private Money setupFee;
    private Money shippingAmount;
    private Money taxes;
    private Money productPrice;
    private Money subtotal;
    private Money totalAmount;

    /**
     * Default constructor.
     */
    public OneTimeCharge() {
    }

    /**
     * Initialization constructor.
     * @param  totalAmount  Money value for totalAmount.
     * @param  setupFee  Money value for setupFee.
     * @param  shippingAmount  Money value for shippingAmount.
     * @param  taxes  Money value for taxes.
     * @param  productPrice  Money value for productPrice.
     * @param  subtotal  Money value for subtotal.
     */
    public OneTimeCharge(
            Money totalAmount,
            Money setupFee,
            Money shippingAmount,
            Money taxes,
            Money productPrice,
            Money subtotal) {
        this.setupFee = setupFee;
        this.shippingAmount = shippingAmount;
        this.taxes = taxes;
        this.productPrice = productPrice;
        this.subtotal = subtotal;
        this.totalAmount = totalAmount;
    }

    /**
     * Getter for SetupFee.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @return Returns the Money
     */
    @JsonGetter("setup_fee")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Money getSetupFee() {
        return setupFee;
    }

    /**
     * Setter for SetupFee.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @param setupFee Value for Money
     */
    @JsonSetter("setup_fee")
    public void setSetupFee(Money setupFee) {
        this.setupFee = setupFee;
    }

    /**
     * Getter for ShippingAmount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @return Returns the Money
     */
    @JsonGetter("shipping_amount")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Money getShippingAmount() {
        return shippingAmount;
    }

    /**
     * Setter for ShippingAmount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @param shippingAmount Value for Money
     */
    @JsonSetter("shipping_amount")
    public void setShippingAmount(Money shippingAmount) {
        this.shippingAmount = shippingAmount;
    }

    /**
     * Getter for Taxes.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @return Returns the Money
     */
    @JsonGetter("taxes")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Money getTaxes() {
        return taxes;
    }

    /**
     * Setter for Taxes.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @param taxes Value for Money
     */
    @JsonSetter("taxes")
    public void setTaxes(Money taxes) {
        this.taxes = taxes;
    }

    /**
     * Getter for ProductPrice.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @return Returns the Money
     */
    @JsonGetter("product_price")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Money getProductPrice() {
        return productPrice;
    }

    /**
     * Setter for ProductPrice.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @param productPrice Value for Money
     */
    @JsonSetter("product_price")
    public void setProductPrice(Money productPrice) {
        this.productPrice = productPrice;
    }

    /**
     * Getter for Subtotal.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @return Returns the Money
     */
    @JsonGetter("subtotal")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Money getSubtotal() {
        return subtotal;
    }

    /**
     * Setter for Subtotal.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @param subtotal Value for Money
     */
    @JsonSetter("subtotal")
    public void setSubtotal(Money subtotal) {
        this.subtotal = subtotal;
    }

    /**
     * Getter for TotalAmount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @return Returns the Money
     */
    @JsonGetter("total_amount")
    public Money getTotalAmount() {
        return totalAmount;
    }

    /**
     * Setter for TotalAmount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @param totalAmount Value for Money
     */
    @JsonSetter("total_amount")
    public void setTotalAmount(Money totalAmount) {
        this.totalAmount = totalAmount;
    }

    /**
     * Converts this OneTimeCharge into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "OneTimeCharge [" + "totalAmount=" + totalAmount + ", setupFee=" + setupFee
                + ", shippingAmount=" + shippingAmount + ", taxes=" + taxes + ", productPrice="
                + productPrice + ", subtotal=" + subtotal + "]";
    }

    /**
     * Builds a new {@link OneTimeCharge.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link OneTimeCharge.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder(totalAmount)
                .setupFee(getSetupFee())
                .shippingAmount(getShippingAmount())
                .taxes(getTaxes())
                .productPrice(getProductPrice())
                .subtotal(getSubtotal());
        return builder;
    }

    /**
     * Class to build instances of {@link OneTimeCharge}.
     */
    public static class Builder {
        private Money totalAmount;
        private Money setupFee;
        private Money shippingAmount;
        private Money taxes;
        private Money productPrice;
        private Money subtotal;

        /**
         * Initialization constructor.
         */
        public Builder() {
        }

        /**
         * Initialization constructor.
         * @param  totalAmount  Money value for totalAmount.
         */
        public Builder(Money totalAmount) {
            this.totalAmount = totalAmount;
        }

        /**
         * Setter for totalAmount.
         * @param  totalAmount  Money value for totalAmount.
         * @return Builder
         */
        public Builder totalAmount(Money totalAmount) {
            this.totalAmount = totalAmount;
            return this;
        }

        /**
         * Setter for setupFee.
         * @param  setupFee  Money value for setupFee.
         * @return Builder
         */
        public Builder setupFee(Money setupFee) {
            this.setupFee = setupFee;
            return this;
        }

        /**
         * Setter for shippingAmount.
         * @param  shippingAmount  Money value for shippingAmount.
         * @return Builder
         */
        public Builder shippingAmount(Money shippingAmount) {
            this.shippingAmount = shippingAmount;
            return this;
        }

        /**
         * Setter for taxes.
         * @param  taxes  Money value for taxes.
         * @return Builder
         */
        public Builder taxes(Money taxes) {
            this.taxes = taxes;
            return this;
        }

        /**
         * Setter for productPrice.
         * @param  productPrice  Money value for productPrice.
         * @return Builder
         */
        public Builder productPrice(Money productPrice) {
            this.productPrice = productPrice;
            return this;
        }

        /**
         * Setter for subtotal.
         * @param  subtotal  Money value for subtotal.
         * @return Builder
         */
        public Builder subtotal(Money subtotal) {
            this.subtotal = subtotal;
            return this;
        }

        /**
         * Builds a new {@link OneTimeCharge} object using the set fields.
         * @return {@link OneTimeCharge}
         */
        public OneTimeCharge build() {
            return new OneTimeCharge(totalAmount, setupFee, shippingAmount, taxes, productPrice,
                    subtotal);
        }
    }
}
