/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;


/**
 * EnrollmentStatus to be used.
 */
public enum EnrollmentStatus {
    /**
     * Yes. The bank is participating in 3-D Secure protocol and will return the ACSUrl.
     */
    ENROLLED,

    /**
     * No. The bank is not participating in 3-D Secure protocol.
     */
    NOTENROLLED,

    /**
     * Unavailable. The DS or ACS is not available for authentication at the time of the request.
     */
    UNAVAILABLE,

    /**
     * Bypass. The merchant authentication rule is triggered to bypass authentication.
     */
    BYPASS,

    /**
     * Unknown values will be mapped by this enum member
     */
    _UNKNOWN;


    private static TreeMap<String, EnrollmentStatus> valueMap = new TreeMap<>();
    private String value;

    static {
        ENROLLED.value = "Y";
        NOTENROLLED.value = "N";
        UNAVAILABLE.value = "U";
        BYPASS.value = "B";
        _UNKNOWN.value = null;

        valueMap.put("Y", ENROLLED);
        valueMap.put("N", NOTENROLLED);
        valueMap.put("U", UNAVAILABLE);
        valueMap.put("B", BYPASS);
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     * @throws IOException when provided value is not mapped to any enum member.
     */
    @JsonCreator
    public static EnrollmentStatus constructFromString(String toConvert) throws IOException {
        EnrollmentStatus enumValue = fromString(toConvert);
        if (enumValue == null) {
            throw new IOException("Unable to create enum instance with value: " + toConvert);
        }
        return enumValue;
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     */
    public static EnrollmentStatus fromString(String toConvert) {
        if (!valueMap.containsKey(toConvert)) {
            return _UNKNOWN;
        }
        return valueMap.get(toConvert);
    }

    /**
     * Returns the string value associated with the enum member.
     * @return The string value against enum member.
     */
    @JsonValue
    public String value() {
        return value;
    }
        
    /**
     * Get string representation of this enum.
     */
    @Override
    public String toString() {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    /**
     * Convert list of EnrollmentStatus values to list of string values.
     * @param toConvert The list of EnrollmentStatus values to convert.
     * @return List of representative string values.
     */
    public static List<String> toValue(List<EnrollmentStatus> toConvert) {
        if (toConvert == null) {
            return null;
        }
        List<String> convertedValues = new ArrayList<>();
        for (EnrollmentStatus enumValue : toConvert) {
            convertedValues.add(enumValue.value);
        }
        return convertedValues;
    }
} 